/*
 * Decompiled with CFR 0.152.
 */
package com.ezware.oxbow.swingbits.util;

import com.ezware.oxbow.swingbits.util.DeepCopyException;
import com.ezware.oxbow.swingbits.util.copy.FastByteArrayInputStream;
import com.ezware.oxbow.swingbits.util.copy.FastByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class DeepCopy {
    public static final <T extends Serializable> T copy(T originalObject) {
        return DeepCopy.restore((FastByteArrayInputStream)DeepCopy.store(originalObject).getInputStream());
    }

    public static final <T extends Serializable> FastByteArrayOutputStream store(T obj) {
        try {
            FastByteArrayOutputStream fbos = new FastByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(fbos);
            out.writeObject(obj);
            out.flush();
            out.close();
            return fbos;
        }
        catch (Throwable ex) {
            throw new DeepCopyException("An " + obj.getClass().getSimpleName() + " cannot be serialized. The reason: " + ex.getLocalizedMessage(), ex);
        }
    }

    public static final <T extends Serializable> T restore(FastByteArrayInputStream stream) {
        try {
            ObjectInputStream in = new ObjectInputStream(stream);
            return (T)((Serializable)in.readObject());
        }
        catch (Throwable ex) {
            throw new DeepCopyException("An object cannot be deserizalized. The reason: " + ex.getLocalizedMessage(), ex);
        }
    }
}

