/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.AddSpeciesAction;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SelectOtherSpeciesAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AddSpeciesAction.class);
    protected Species selectedSpecies;

    public SelectOtherSpeciesAction(EditProtocolUIHandler handler) {
        super(handler, "selectOtherSpecies", null, I18n._((String)"tutti.action.selectOtherSpecies.text", (Object[])new Object[0]), I18n._((String)"tutti.action.selectOtherSpecies.tip", (Object[])new Object[0]), false);
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {
        boolean result = super.prepareAction(event);
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        ArrayList species = Lists.newArrayList(model.getAllSynonyms());
        this.selectedSpecies = ((EditProtocolUIHandler)this.getHandler()).openSelectOtherSpeciesDialog(I18n._((String)"tutti.title.selectSpecies", (Object[])new Object[0]), species);
        return result &= this.selectedSpecies != null;
    }

    @Override
    protected void doAction(ActionEvent event) {
        String decoratedSynonym = this.decorate(this.selectedSpecies);
        String taxonId = String.valueOf(this.selectedSpecies.getReferenceTaxonId());
        this.selectedSpecies = ((EditProtocolUIModel)this.getModel()).getAllReferentSpeciesByTaxonId().get(taxonId);
        String decoratedReferent = this.decorate(this.selectedSpecies);
        this.sendMessage(I18n._((String)"tutti.flash.information.species.replaced", (Object[])new Object[]{decoratedSynonym, decoratedReferent}));
        ((EditProtocolUI)this.getUI()).getSpeciesComboBox().setSelectedItem((Object)this.selectedSpecies);
    }
}

