/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SaveProtocolAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(SaveProtocolAction.class);
    private static final long serialVersionUID = 1L;

    public SaveProtocolAction(EditProtocolUIHandler handler) {
        super(handler, "saveProtocol", "save", I18n._((String)"tutti.action.saveProtocol", (Object[])new Object[0]), I18n._((String)"tutti.action.saveProtocol.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected void doAction(ActionEvent event) {
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        TuttiUIContext context = this.getContext();
        EditProtocolUIHandler handler = (EditProtocolUIHandler)this.getHandler();
        PersistenceService persistenceService = context.getService(PersistenceService.class);
        TuttiProtocol bean = (TuttiProtocol)model.toBean();
        ArrayList protocols = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : handler.getTableModel().getRows()) {
            if (!row.isValid()) continue;
            SpeciesProtocol protocol = (SpeciesProtocol)row.toBean();
            protocols.add(protocol);
        }
        bean.setSpecies(protocols);
        if (log.isDebugEnabled()) {
            log.debug((Object)("protocol id to save: " + bean.getId()));
        }
        TuttiProtocol saved = TuttiEntities.isNew(bean) ? persistenceService.createProtocol(bean) : persistenceService.saveProtocol(bean);
        context.setProtocolId(saved.getId());
        TuttiScreen nextScreen = event.getSource().getClass().isAssignableFrom(TuttiScreen.class) ? (TuttiScreen)((Object)event.getSource()) : TuttiScreen.SELECT_CRUISE;
        context.setScreen(nextScreen);
    }
}

