/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology.HydrologyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology.HydrologyTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology.HydrologyTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology.HydrologyTableModel;
import fr.ifremer.tutti.ui.swing.util.HydrologicCaracteristicUtil;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.editor.CaracteristicValueEditor;
import fr.ifremer.tutti.ui.swing.util.editor.CaracteristicValueRenderer;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;

public class HydrologyTabUIHandler
extends AbstractTuttiTableUIHandler<HydrologyRowModel, HydrologyTabUIModel> {
    private static final Log log = LogFactory.getLog(HydrologyTabUIHandler.class);
    protected final HydrologyTabUI ui;
    protected Map<Caracteristic, Map<HydrologicCaracteristicUtil.Type, Caracteristic>> availableGlobalCaracteristics;

    public HydrologyTabUIHandler(EditFishingOperationUI parentUi, HydrologyTabUI ui) {
        super(parentUi.getHandler().getContext(), "gearShootingStartValue", "averageValue", "gearShootingEndValue");
        this.ui = ui;
    }

    @Override
    protected JXTable getTable() {
        return this.ui.getHydrologyTable();
    }

    protected HydrologyTableModel getTableModel() {
        return (HydrologyTableModel)this.getTable().getModel();
    }

    @Override
    protected boolean isRowValid(HydrologyRowModel row) {
        return row.getGearShootingStartValue() != null || row.getGearShootingEndValue() != null || row.getAverageValue() != null;
    }

    @Override
    protected void onRowModified(int rowIndex, HydrologyRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        super.onRowModified(rowIndex, row, propertyName, oldValue, newValue);
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<HydrologyRowModel> rowMonitor, HydrologyRowModel row) {
        if (row.isValid() && rowMonitor.wasModified()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Row " + (Object)((Object)row) + " was modified, will save it"));
            }
            this.showInformationMessage("[ Trait - Hydro ] Sauvegarde des modifications de " + (Object)((Object)row) + ".");
            this.saveRow(row);
            rowMonitor.clearModified();
            this.getModel().setModify(false);
        }
    }

    @Override
    protected HydrologyTabUIModel getModel() {
        return this.ui.getModel();
    }

    @Override
    public void beforeInitUI() {
        HydrologyTabUIModel model = new HydrologyTabUIModel();
        this.ui.setContextValue(model);
        model.addPropertyChangeListener("availableCaracteristics", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List hydrologyPmfm = (List)evt.getNewValue();
                HydrologyTabUIHandler.this.availableGlobalCaracteristics = Maps.newHashMap();
                if (hydrologyPmfm != null) {
                    for (Caracteristic caracteristic : hydrologyPmfm) {
                        String name = HydrologicCaracteristicUtil.getGlobalName(caracteristic.getName());
                        Caracteristic globalCaracteristic = HydrologicCaracteristicUtil.createGlobalCaracteristic(name, caracteristic);
                        HashMap values = HydrologyTabUIHandler.this.availableGlobalCaracteristics.get(globalCaracteristic);
                        if (values == null) {
                            values = Maps.newHashMap();
                            HydrologyTabUIHandler.this.availableGlobalCaracteristics.put(globalCaracteristic, values);
                        }
                        HydrologicCaracteristicUtil.Type type = HydrologicCaracteristicUtil.getTypeOfCaracteristic(caracteristic);
                        values.put(type, caracteristic);
                    }
                }
            }
        });
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        this.initBeanComboBox(this.ui.getNewRowKey(), Lists.newArrayList(), null);
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Caracteristic.class, "withUnit"), HydrologyTableModel.KEY);
        this.addColumnToModel((TableColumnModel)columnModel, new CaracteristicValueEditor(this.context), new CaracteristicValueRenderer(this.context), HydrologyTableModel.GEAR_SHOOTING_START_VALUE);
        this.addColumnToModel((TableColumnModel)columnModel, new CaracteristicValueEditor(this.context), new CaracteristicValueRenderer(this.context), HydrologyTableModel.GEAR_SHOOTING_END_VALUE);
        this.addColumnToModel((TableColumnModel)columnModel, new CaracteristicValueEditor(this.context), new CaracteristicValueRenderer(this.context), HydrologyTableModel.AVERAGE_VALUE);
        HydrologyTableModel tableModel = new HydrologyTableModel((TableColumnModel)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, HydrologyRowModel oldRow, int newRowIndex, HydrologyRowModel newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        this.getModel().setRemoveCaracteristicEnabled(newRow != null);
    }

    public void addRow() {
        BeanComboBox<Caracteristic> keyCombo = this.ui.getNewRowKey();
        Caracteristic selectedItem = (Caracteristic)keyCombo.getSelectedItem();
        HydrologyRowModel row = this.getTableModel().createNewRow();
        row.setKey(selectedItem);
        this.getModel().getRows().add(row);
        HydrologyTableModel tableModel = this.getTableModel();
        int rowIndex = tableModel.getRowCount() - 1;
        tableModel.fireTableRowsInserted(rowIndex, rowIndex);
        keyCombo.removeItem((Object)selectedItem);
        this.selectFirstInCombo(keyCombo);
        HydrologyTabUIModel model = this.getModel();
        model.setModify(true);
        model.setValid(row.isValid());
    }

    public void reset(FishingOperation fishingOperation) {
        List protocolHydrologyPmfmId;
        HydrologyTableModel tableModel = this.getTableModel();
        HydrologyTabUIModel model = this.getModel();
        model.setFishingOperation(fishingOperation);
        CaracteristicMap hydrologyCaracteristics = fishingOperation.getHydrologyCaracteristics();
        if (hydrologyCaracteristics == null) {
            hydrologyCaracteristics = new CaracteristicMap();
        }
        TuttiProtocol protocol = this.ui.getContextValue(TuttiProtocol.class);
        ArrayList gearPmfmIds = Lists.newArrayList();
        if (protocol != null && (protocolHydrologyPmfmId = protocol.getHydrologyPmfmId()) != null) {
            gearPmfmIds.addAll(protocolHydrologyPmfmId);
        }
        ArrayList rows = Lists.newArrayList();
        ArrayList caracteristicList = Lists.newArrayList();
        ArrayList selectedCaracteristics = Lists.newArrayList((Iterable)hydrologyCaracteristics.keySet());
        List<Caracteristic> availableCaracteristics = model.getAvailableCaracteristics();
        for (String id : gearPmfmIds) {
            Caracteristic caracteristic = (Caracteristic)TuttiEntities.findById(availableCaracteristics, (String)id);
            if (selectedCaracteristics.contains(caracteristic)) continue;
            selectedCaracteristics.add(caracteristic);
        }
        Set<Caracteristic> globalCaracteristics = this.availableGlobalCaracteristics.keySet();
        for (Caracteristic availableCaracteristic : globalCaracteristics) {
            Map<HydrologicCaracteristicUtil.Type, Caracteristic> caracteristics = this.availableGlobalCaracteristics.get(availableCaracteristic);
            boolean selectedCaracteristic = false;
            for (Caracteristic caracteristic : caracteristics.values()) {
                selectedCaracteristic |= selectedCaracteristics.contains(caracteristic);
            }
            if (selectedCaracteristic) {
                HydrologyRowModel row = tableModel.createNewRow();
                row.setKey(availableCaracteristic);
                row.setGearShootingStartValue((Serializable)hydrologyCaracteristics.get((Object)caracteristics.get((Object)HydrologicCaracteristicUtil.Type.START)));
                row.setGearShootingEndValue((Serializable)hydrologyCaracteristics.get((Object)caracteristics.get((Object)HydrologicCaracteristicUtil.Type.END)));
                row.setAverageValue((Serializable)hydrologyCaracteristics.get((Object)caracteristics.get((Object)HydrologicCaracteristicUtil.Type.AVERAGE)));
                rows.add(row);
                continue;
            }
            caracteristicList.add(availableCaracteristic);
        }
        model.setRows(rows);
        this.ui.getNewRowKey().setData((List)caracteristicList);
        this.selectFirstInCombo(this.ui.getNewRowKey());
        model.setModify(false);
    }

    public void removeCaracteristic() {
        int rowIndex = this.getTable().getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove caracteristic if no caracteristic selected");
        HydrologyRowModel row = (HydrologyRowModel)((Object)this.getTableModel().getEntry(rowIndex));
        FishingOperation fishingOperation = this.getModel().getFishingOperation();
        Preconditions.checkNotNull((Object)fishingOperation);
        Map<HydrologicCaracteristicUtil.Type, Caracteristic> caracteristics = this.availableGlobalCaracteristics.get(row.getKey());
        for (HydrologicCaracteristicUtil.Type type : caracteristics.keySet()) {
            Caracteristic caracteristic = caracteristics.get((Object)type);
            fishingOperation.getHydrologyCaracteristics().remove((Object)caracteristic);
        }
        if (TuttiEntities.isNew((IdAware)fishingOperation)) {
            fishingOperation = this.persistenceService.createFishingOperation(fishingOperation);
        } else {
            this.persistenceService.saveFishingOperation(fishingOperation);
        }
        BeanComboBox<Caracteristic> keyCombo = this.ui.getNewRowKey();
        keyCombo.addItem((Object)row.getKey());
        this.selectFirstInCombo(keyCombo);
        this.getModel().getRows().remove(rowIndex);
        this.getTableModel().fireTableRowsDeleted(rowIndex, rowIndex);
    }

    protected void saveRow(HydrologyRowModel row) {
        FishingOperation fishingOperation = this.getModel().getFishingOperation();
        Preconditions.checkNotNull((Object)fishingOperation);
        if (fishingOperation.getHydrologyCaracteristics() == null) {
            fishingOperation.setHydrologyCaracteristics(new CaracteristicMap());
        }
        Map<HydrologicCaracteristicUtil.Type, Caracteristic> caracteristics = this.availableGlobalCaracteristics.get(row.getKey());
        CaracteristicMap map = new CaracteristicMap();
        for (HydrologicCaracteristicUtil.Type type : caracteristics.keySet()) {
            Serializable value = null;
            switch (type) {
                case START: {
                    value = row.getGearShootingStartValue();
                    break;
                }
                case END: {
                    value = row.getGearShootingEndValue();
                    break;
                }
                case AVERAGE: {
                    value = row.getAverageValue();
                }
            }
            map.put((Object)caracteristics.get((Object)type), (Object)value);
        }
        fishingOperation.getHydrologyCaracteristics().putAll((Map)map);
        if (TuttiEntities.isNew((IdAware)fishingOperation)) {
            fishingOperation = this.persistenceService.createFishingOperation(fishingOperation);
        } else {
            this.persistenceService.saveFishingOperation(fishingOperation);
        }
    }
}

