/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class CreateSpeciesBatchUIHandler
extends AbstractTuttiUIHandler<CreateSpeciesBatchUIModel>
implements Cancelable {
    private static final Log log = LogFactory.getLog(CreateSpeciesBatchUIHandler.class);
    private final CreateSpeciesBatchUI ui;
    private final TuttiPersistence persistenceService;
    private final CaracteristicQualitativeValue sortedValue;

    public CreateSpeciesBatchUIHandler(SpeciesBatchUI parentUi, CreateSpeciesBatchUI ui) {
        super(parentUi.getHandler().getContext());
        this.ui = ui;
        this.persistenceService = (TuttiPersistence)this.context.getService(PersistenceService.class);
        Caracteristic caracteristic = this.persistenceService.getSortedUnsortedCaracteristic();
        CaracteristicQualitativeValue v = null;
        for (CaracteristicQualitativeValue value : caracteristic.getQualitativeValue()) {
            if (!this.persistenceService.isSortedQualitativeValue(value)) continue;
            v = value;
            break;
        }
        this.sortedValue = v;
    }

    @Override
    public void beforeInitUI() {
        CreateSpeciesBatchUIModel model = new CreateSpeciesBatchUIModel();
        this.ui.setContextValue(model);
        this.listModelIsModify(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        this.initBeanComboBox(this.ui.getSpeciesComboBox(), Lists.newArrayList(), null);
        Caracteristic caracteristic = this.persistenceService.getSortedUnsortedCaracteristic();
        this.initBeanComboBox(this.ui.getSortedUnsortedCategoryComboBox(), caracteristic.getQualitativeValue(), null);
        this.getModel().addPropertyChangeListener("species", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CreateSpeciesBatchUIModel source = (CreateSpeciesBatchUIModel)((Object)evt.getSource());
                Species newValue = (Species)evt.getNewValue();
                if (log.isInfoEnabled()) {
                    log.info((Object)("New Selected species " + (newValue == null ? null : newValue.getCodeMemo())));
                }
                if (newValue == null || source.getSpeciesUsed() == null) {
                    source.setSortedUnsortedCategory(null);
                } else {
                    CaracteristicQualitativeValue qualitativeValue;
                    List qualitativeValues = CreateSpeciesBatchUIHandler.this.ui.getSortedUnsortedCategoryComboBox().getData();
                    CaracteristicQualitativeValue newCategory = null;
                    Iterator i$ = qualitativeValues.iterator();
                    while (!(!i$.hasNext() || source.isSpeciesAndCategoryAvailable(newValue, qualitativeValue = (CaracteristicQualitativeValue)i$.next()) && (newCategory = qualitativeValue).equals((Object)CreateSpeciesBatchUIHandler.this.sortedValue))) {
                    }
                    source.setSortedUnsortedCategory(newCategory);
                }
            }
        });
        SwingValidatorUtil.installUI((JTable)this.ui.getErrorTable(), (SwingValidatorMessageTableRenderer)new SwingValidatorMessageTableRenderer());
        this.listenValidatorValid((SimpleBeanValidator)this.ui.getValidator(), this.getModel());
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
    }

    @Override
    protected CreateSpeciesBatchUIModel getModel() {
        return this.ui.getModel();
    }

    @Override
    public void cancel() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Cancel UI " + this.ui));
        }
        this.ui.getValidator().setBean(null);
        this.getModel().setValid(false);
        this.closeDialog(this.ui);
    }

    public void openUI(SpeciesBatchUIModel batchModel) {
        CreateSpeciesBatchUIModel model = this.getModel();
        this.ui.getValidator().setBean((Object)model);
        model.setSpecies(null);
        model.setSortedUnsortedCategory(null);
        model.setBatchWeight(null);
        ArrayList speciesToUse = Lists.newArrayList();
        Multimap<CaracteristicQualitativeValue, Species> speciesUsed = model.getSpeciesUsed();
        speciesUsed.clear();
        if (batchModel != null) {
            speciesUsed.putAll(batchModel.getSpeciesUsed());
            List<Species> allSpecies = batchModel.getAllSpecies();
            speciesToUse.addAll(allSpecies);
        }
        this.ui.getSpeciesComboBox().setData((List)speciesToUse);
    }

    public void save() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Save UI " + this.ui));
        }
        this.closeDialog(this.ui);
    }
}

