/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import com.ezware.oxbow.swingbits.util.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class SpeciesFrequencyUIHandler
extends AbstractTuttiTableUIHandler<SpeciesFrequencyRowModel, SpeciesFrequencyUIModel>
implements Cancelable {
    private static final Log log = LogFactory.getLog(SpeciesFrequencyUIHandler.class);
    private final SpeciesFrequencyUI ui;

    public SpeciesFrequencyUIHandler(TuttiUIContext context, SpeciesFrequencyUI ui) {
        super(context, "lengthStep", "number", "weight", "computedWeight");
        this.ui = ui;
    }

    protected SpeciesFrequencyTableModel getTableModel() {
        return (SpeciesFrequencyTableModel)this.getTable().getModel();
    }

    @Override
    protected JXTable getTable() {
        return this.ui.getTable();
    }

    @Override
    protected boolean isRowValid(SpeciesFrequencyRowModel row) {
        return row.getLengthStepCaracteristic() != null && row.getLengthStep() != null && row.getNumber() != null;
    }

    @Override
    protected void onRowModified(int rowIndex, SpeciesFrequencyRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        if ("number".equals(propertyName)) {
            this.computeComputedWeight(row);
        }
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<SpeciesFrequencyRowModel> rowMonitor, SpeciesFrequencyRowModel row) {
    }

    @Override
    protected void onRowValidStateChanged(int rowIndex, SpeciesFrequencyRowModel row, Boolean oldValue, Boolean newValue) {
        super.onRowValidStateChanged(rowIndex, row, oldValue, newValue);
        this.ui.getValidator().doValidate();
    }

    @Override
    protected SpeciesFrequencyUIModel getModel() {
        return this.ui.getModel();
    }

    @Override
    public void beforeInitUI() {
        SpeciesFrequencyUIModel model = new SpeciesFrequencyUIModel();
        this.ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        List lengthStepCaracterics = (List)SpeciesBatchUIHandler.FREQUENCY_LENGTH_CONTEXT_ENTRY.getContextValue((JAXXContext)this.ui);
        Preconditions.checkNotNull((Object)lengthStepCaracterics);
        SpeciesFrequencyUIModel model = this.getModel();
        this.initBeanComboBox(this.ui.getLengthStepCaracteristicComboBox(), lengthStepCaracterics, model.getLengthStepCaracteristic());
        model.setStep(0.5f);
        model.setMinStep(Float.valueOf(10.0f));
        model.setMaxStep(Float.valueOf(20.0f));
        model.setConfigurationMode(SpeciesFrequencyUIModel.ConfigurationMode.SIMPLE);
        this.ui.getRafaleStepField().getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    Float step = (Float)SpeciesFrequencyUIHandler.this.ui.getRafaleStepField().getModel();
                    SpeciesFrequencyUIHandler.this.applyRafaleStep(step);
                }
            }
        });
        model.addPropertyChangeListener("lengthStepCaracteristic", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Caracteristic newValue = (Caracteristic)evt.getNewValue();
                for (SpeciesFrequencyRowModel rowModel : SpeciesFrequencyUIHandler.this.getModel().getRows()) {
                    rowModel.setLengthStepCaracteristic(newValue);
                    SpeciesFrequencyUIHandler.this.recomputeRowValidState(rowModel);
                }
                SpeciesFrequencyUIHandler.this.ui.getValidator().doValidate();
            }
        });
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.LENGTH_STEP, "\\d{0,6}|\\d{1,6}.\\d{0,1}");
        this.addIntegerColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.NUMBER, "\\d{0,6}");
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.WEIGHT, "\\d{0,6}|\\d{1,6}.\\d{0,3}");
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.COMPUTED_WEIGHT, "\\d{0,6}|\\d{1,6}.\\d{0,3}");
        SpeciesFrequencyTableModel tableModel = new SpeciesFrequencyTableModel((TableColumnModel)columnModel, model);
        JXTable table = this.getTable();
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.installTableKeyListener((TableColumnModel)columnModel, (JTable)table);
        this.initTable(table);
        SwingValidatorUtil.installUI((JTable)this.ui.getErrorTable(), (SwingValidatorMessageTableRenderer)new SwingValidatorMessageTableRenderer());
        this.listenValidatorValid((SimpleBeanValidator)this.ui.getValidator(), model);
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
    }

    @Override
    public void cancel() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Cancel UI " + this.ui));
        }
        this.ui.getValidator().setBean(null);
        this.getModel().setValid(false);
        this.closeDialog(this.ui);
    }

    public void generateLengthSteps() {
        SpeciesFrequencyUIModel model = this.getModel();
        SpeciesFrequencyTableModel tableModel = this.getTableModel();
        Map<Float, SpeciesFrequencyRowModel> rowsByStep = this.getTableModel().getRowCache();
        Float minStep = Float.valueOf(model.getLengthStep(model.getMinStep().floatValue()));
        Float maxStep = Float.valueOf(model.getLengthStep(model.getMaxStep().floatValue()));
        float step = model.getStep();
        for (float i = minStep.floatValue(); i <= maxStep.floatValue(); i += step) {
            if (rowsByStep.containsKey(Float.valueOf(i))) continue;
            SpeciesFrequencyRowModel newRow = tableModel.createNewRow();
            newRow.setLengthStep(Float.valueOf(i));
            rowsByStep.put(Float.valueOf(i), newRow);
        }
        ArrayList rows = Lists.newArrayList(rowsByStep.values());
        model.setRows(rows);
    }

    public void applyRafaleStep(Float step) {
        int rowIndex;
        float aroundLengthStep;
        if (log.isInfoEnabled()) {
            log.info((Object)("Will apply rafale step: " + step));
        }
        SpeciesFrequencyUIModel model = this.getModel();
        SpeciesFrequencyTableModel tableModel = this.getTableModel();
        Map<Float, SpeciesFrequencyRowModel> rowsByStep = tableModel.getRowCache();
        SpeciesFrequencyRowModel row = rowsByStep.get(Float.valueOf(aroundLengthStep = model.getLengthStep(step.floatValue())));
        if (row != null) {
            Integer number = row.getNumber();
            row.setNumber((number == null ? 0 : number) + 1);
            rowIndex = tableModel.updateRow(row);
        } else {
            row = tableModel.createNewRow();
            row.setLengthStep(Float.valueOf(aroundLengthStep));
            row.setNumber(1);
            ArrayList steps = Lists.newArrayList(rowsByStep.keySet());
            steps.add(Float.valueOf(aroundLengthStep));
            Collections.sort(steps);
            rowIndex = steps.indexOf(Float.valueOf(aroundLengthStep));
            tableModel.addNewRow(rowIndex, row);
        }
        this.getTable().scrollRowToVisible(rowIndex);
    }

    public void editBatch(SpeciesBatchRowModel speciesBatch) {
        List<SpeciesFrequencyRowModel> frequency = null;
        Caracteristic lengthStepCaracteristic = null;
        if (speciesBatch != null) {
            frequency = speciesBatch.getFrequency();
        }
        ArrayList editFrequency = Lists.newArrayList();
        if (frequency != null) {
            SpeciesFrequencyTableModel tableModel = this.getTableModel();
            for (SpeciesFrequencyRowModel rowModel : frequency) {
                SpeciesFrequencyRowModel newRow = tableModel.createNewRow();
                newRow.setLengthStepCaracteristic(rowModel.getLengthStepCaracteristic());
                newRow.setLengthStep(rowModel.getLengthStep());
                newRow.setNumber(rowModel.getNumber());
                newRow.setComputedWeight(rowModel.getComputedWeight());
                editFrequency.add(newRow);
            }
            if (CollectionUtils.isNotEmpty(frequency)) {
                lengthStepCaracteristic = frequency.get(0).getLengthStepCaracteristic();
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will edit batch row: " + (Object)((Object)speciesBatch) + " with " + editFrequency.size() + " frequency"));
        }
        SpeciesFrequencyUIModel model = this.getModel();
        this.ui.getValidator().setBean((Object)model);
        model.setRows(editFrequency);
        if (lengthStepCaracteristic == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"No lengthStepCaracteristic to set.");
            }
            model.setLengthStepCaracteristic(null);
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Use lengthStepCaracteristic: " + lengthStepCaracteristic.getName()));
            }
            model.setLengthStepCaracteristic(lengthStepCaracteristic);
        }
        model.setBatch(speciesBatch);
    }

    public void save() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Save UI " + this.ui));
        }
        this.closeDialog(this.ui);
    }

    protected void computeComputedWeight(SpeciesFrequencyRowModel row) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will recompute computed weight for frequency: " + row));
        }
    }
}

