/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiTabContainerUIHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.List;
import javax.swing.JTabbedPane;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public class FishingOperationsUIHandler
extends AbstractTuttiTabContainerUIHandler<FishingOperationsUIModel> {
    private static final Log log = LogFactory.getLog(FishingOperationsUIHandler.class);
    private final FishingOperationsUI ui;
    private final PersistenceService persistenceService;

    public FishingOperationsUIHandler(TuttiUI parentUI, FishingOperationsUI ui) {
        super(((AbstractTuttiUIHandler)parentUI.getHandler()).getContext());
        this.ui = ui;
        this.persistenceService = this.context.getService(PersistenceService.class);
    }

    @Override
    public void beforeInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("for " + this.ui));
        }
        FishingOperationsUIModel model = new FishingOperationsUIModel();
        EditCatchesUIModel catchesUIModel = new EditCatchesUIModel();
        String cruiseId = this.context.getCruiseId();
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        model.setCruise(cruise);
        if (this.getContext().isProtocolFilled()) {
            TuttiProtocol protocol = this.persistenceService.getProtocol(this.getContext().getProtocolId());
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading existing protocol: " + protocol));
            }
            this.ui.setContextValue(protocol);
        } else {
            this.ui.removeContextValue(TuttiProtocol.class);
        }
        List fishingOperations = this.persistenceService.getAllFishingOperation(cruiseId);
        model.setFishingOperation(fishingOperations);
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded " + fishingOperations.size() + " fishingOperation(s)."));
        }
        this.ui.setContextValue(model);
        this.ui.setContextValue(catchesUIModel);
    }

    @Override
    public void afterInitUI() {
        FishingOperationsUIModel model = this.getModel();
        this.initUI(this.ui);
        List<FishingOperation> fishingOperations = model.getFishingOperation();
        this.initBeanComboBox(this.ui.getFishingOperationComboBox(), fishingOperations, model.getSelectedFishingOperation());
        model.addPropertyChangeListener("selectedFishingOperation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FishingOperationsUIHandler.this.selectFishingOperation((FishingOperation)evt.getNewValue());
            }
        });
        model.addPropertyChangeListener("fishingOperation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FishingOperationsUIHandler.this.ui.getFishingOperationComboBox().setData(null);
                FishingOperationsUIHandler.this.ui.getFishingOperationComboBox().setData((List)evt.getNewValue());
            }
        });
        if (!fishingOperations.isEmpty()) {
            model.setSelectedFishingOperation(fishingOperations.get(0));
        }
    }

    @Override
    public void onCloseUI() {
        this.ui.getTabPane().setSelectedIndex(0);
        this.ui.getFishingOperationTabContent().getFishingOperationTabPane().setSelectedIndex(0);
        this.selectFishingOperation(null);
        this.closeUI(this.ui.getFishingOperationTabContent());
        this.closeUI(this.ui.getCatchesTabContent());
    }

    @Override
    protected FishingOperationsUIModel getModel() {
        return this.ui.getModel();
    }

    @Override
    protected JTabbedPane getTabPanel() {
        return this.ui.getTabPane();
    }

    public void createNewFishingOperation() {
        FishingOperationsUIModel model = this.getModel();
        model.setSelectedFishingOperation(null);
        FishingOperation newFishingOperation = new FishingOperation();
        newFishingOperation.setCruise(model.getCruise());
        Date currentDate = new Date();
        currentDate = DateUtils.setHours((Date)currentDate, (int)0);
        currentDate = DateUtils.setMinutes((Date)currentDate, (int)0);
        newFishingOperation.setDate(currentDate);
        newFishingOperation.setGearShootingStartDate(currentDate);
        newFishingOperation.setGearShootingEndDate(currentDate);
        this.selectFishingOperation(newFishingOperation);
    }

    public void selectFishingOperation(FishingOperation fishingOperation) {
        if (log.isInfoEnabled()) {
            log.info((Object)("New selected fishingOperation: " + fishingOperation));
        }
        this.ui.getTabPane().setSelectedIndex(0);
        this.ui.getFishingOperationTabContent().getFishingOperationTabPane().setSelectedIndex(0);
        if (fishingOperation != null) {
            Decorator<FishingOperation> decorator = this.getDecorator(FishingOperation.class, null);
            String fishingOperationText = I18n._((String)"tutti.label.traitReminder", (Object[])new Object[]{decorator.toString((Object)fishingOperation)});
            this.ui.getFishingOperationTabContent().getHandler().selectFishingOperation(fishingOperation);
            this.ui.getCatchesTabContent().getHandler().selectFishingOperation(fishingOperation, fishingOperationText);
            this.ui.getTabPane().repaint();
        } else {
            this.ui.getFishingOperationTabContent().getHandler().clearFishingOperation();
        }
    }

    public void closeCurrentFishingOperation() {
        this.ui.getFishingOperationTabContent().getHandler().selectFishingOperation(null);
        this.ui.getCatchesTabContent().getHandler().selectFishingOperation(null, "");
    }

    public void saveFishingOperation(FishingOperation toSave) {
        boolean create = toSave.getId() == null;
        FishingOperationsUIModel model = this.getModel();
        if (create) {
            FishingOperation savedFishingOperation = this.persistenceService.createFishingOperation(toSave);
            model.addFishingOperation(savedFishingOperation);
            model.setSelectedFishingOperation(savedFishingOperation);
        } else {
            FishingOperation savedFishingOperation = this.persistenceService.saveFishingOperation(toSave);
            List<FishingOperation> data = model.getFishingOperation();
            FishingOperation existingFishingOperation = (FishingOperation)TuttiEntities.findById(data, (String)savedFishingOperation.getId());
            model.updateFishingOperation(existingFishingOperation, savedFishingOperation);
        }
    }
}

