package fr.ifremer.tutti.ui.swing.content.operation.catches.macrowaste;

/*
 * #%L
 * Tutti :: UI
 * $Id: MacroWasteBatchRowModel.java 132 2012-12-30 19:39:00Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2.5/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/macrowaste/MacroWasteBatchRowModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.MacroWasteBatch;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.List;

/**
 * Define a benthos batch row.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class MacroWasteBatchRowModel extends AbstractTuttiBeanUIModel<MacroWasteBatch, MacroWasteBatchRowModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_MACRO_WASTE_CATEGORY = "macroWasteCategory";

    public static final String PROPERTY_MACRO_WASTE_SIZE_CATEGORY = "macroWasteSizeCategory";

    public static final String PROPERTY_WEIGHT = "weight";

    public static final String PROPERTY_NUMBER = "number";

    public static final String PROPERTY_COMMENT = "comment";

    public static final String PROPERTY_ATTACHMENTS = "attachments";

    /**
     * MacroWaste category.
     *
     * @since 0.2
     */
    protected CaracteristicQualitativeValue macroWasteCategory;

    /**
     * MacroWaste size category.
     *
     * @since 0.3
     */
    protected CaracteristicQualitativeValue macroWasteSizeCategory;

    /**
     * Observed weight.
     *
     * @since 0.2
     */
    protected Float weight;

    /**
     * Observed number.
     *
     * @since 0.3
     */
    protected Integer number;

    /**
     * Comment on this batch.
     *
     * @since 0.2
     */
    protected String comment;

    /**
     * Attachments.
     *
     * @since 0.2
     */
    protected List<Attachment> attachments;

    protected static final Binder<MacroWasteBatch, MacroWasteBatchRowModel> fromBeanBinder =
            BinderFactory.newBinder(MacroWasteBatch.class,
                                    MacroWasteBatchRowModel.class);

    protected static final Binder<MacroWasteBatchRowModel, MacroWasteBatch> toBeanBinder =
            BinderFactory.newBinder(MacroWasteBatchRowModel.class,
                                    MacroWasteBatch.class);

    public MacroWasteBatchRowModel() {
        super(MacroWasteBatch.class, fromBeanBinder, toBeanBinder);
    }

    public MacroWasteBatchRowModel(MacroWasteBatch aBatch) {
        this();
        fromBean(aBatch);
    }

    public CaracteristicQualitativeValue getMacroWasteCategory() {
        return macroWasteCategory;
    }

    public void setMacroWasteCategory(CaracteristicQualitativeValue macroWasteCategory) {
        Object oldValue = getMacroWasteCategory();
        this.macroWasteCategory = macroWasteCategory;
        firePropertyChange(PROPERTY_MACRO_WASTE_CATEGORY, oldValue, macroWasteCategory);
    }

    public CaracteristicQualitativeValue getMacroWasteSizeCategory() {
        return macroWasteSizeCategory;
    }

    public void setMacroWasteSizeCategory(CaracteristicQualitativeValue macroWasteSizeCategory) {
        Object oldValue = getMacroWasteSizeCategory();
        this.macroWasteSizeCategory = macroWasteSizeCategory;
        firePropertyChange(PROPERTY_MACRO_WASTE_SIZE_CATEGORY, oldValue, macroWasteSizeCategory);
    }

    public Float getWeight() {
        return weight;
    }

    public void setWeight(Float weight) {
        Object oldValue = getWeight();
        this.weight = weight;
        firePropertyChange(PROPERTY_WEIGHT, oldValue, weight);
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        Object oldValue = getNumber();
        this.number = number;
        firePropertyChange(PROPERTY_NUMBER, oldValue, number);
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        Object oldValue = getComment();
        this.comment = comment;
        firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    public List<Attachment> getAttachments() {
        return attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        Object oldValue = getAttachments();
        this.attachments = attachments;
        firePropertyChange(PROPERTY_ATTACHMENTS, oldValue, attachments);
    }
}
