package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditCatchesUIHandler.java 138 2013-01-02 10:07:34Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2.5/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/EditCatchesUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class EditCatchesUIHandler extends AbstractTuttiUIHandler<EditCatchesUIModel> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(EditCatchesUIHandler.class);

    /**
     * UI.
     *
     * @since 0.3
     */
    private final EditCatchesUI ui;

    /**
     * Persistence service.
     *
     * @since 0.3
     */
    private final PersistenceService persistenceService;

    /**
     * To monitor changes on the incoming fishing operation.
     *
     * @since 0.3
     */
    private final TuttiBeanMonitor<EditCatchesUIModel> fishingOperationMonitor;

    public EditCatchesUIHandler(FishingOperationsUI parentUi, EditCatchesUI ui) {
        super(parentUi.getHandler().getContext());
        this.ui = ui;
        this.persistenceService = context.getService(PersistenceService.class);
        this.fishingOperationMonitor = new TuttiBeanMonitor<EditCatchesUIModel>(
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_UNSORTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_WEIGHT,
                EditCatchesUIModel.PROPERTY_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT,
                EditCatchesUIModel.PROPERTY_PLANKTON_TOTAL_WEIGHT,
                EditCatchesUIModel.PROPERTY_PLANKTON_TOTAL_SAMPLE_WEIGHT,
                EditCatchesUIModel.PROPERTY_MACRO_WASTE_TOTAL_WEIGHT);
    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiUIHandler methods                                     --//
    //------------------------------------------------------------------------//

    @Override
    public void beforeInitUI() {

        EditCatchesUIModel model = ui.getContextValue(EditCatchesUIModel.class);

        listModelIsModify(model);

        fishingOperationMonitor.setBean(model);
    }

    @Override
    public void afterInitUI() {

        initUI(ui);
    }

    @Override
    public void onCloseUI() {

        if (log.isInfoEnabled()) {
            log.info("closing: " + ui);
        }

        // close batches tabs, then general tab
        closeUI(ui.getSpeciesTabContent());
        closeUI(ui.getBenthosTabContent());
        closeUI(ui.getPlanktonTabContent());
        closeUI(ui.getMacroWasteTabContent());
        closeUI(ui.getAccidentalTabContent());
    }

    @Override
    protected EditCatchesUIModel getModel() {
        return ui.getModel();
    }

    //------------------------------------------------------------------------//
    //-- Public methods                                                     --//
    //------------------------------------------------------------------------//

    public void selectFishingOperation(FishingOperation bean,
                                       String fishingOperationText) {

        // 1) Save any modification of the current fishingOperation

        if (fishingOperationMonitor.wasModified()) {

            // previous fishingOperation was modified, let's save it
            EditCatchesUIModel beanToSave = fishingOperationMonitor.getBean();

            FishingOperation fishingOperation = beanToSave.toBean();

            if (log.isInfoEnabled()) {
                log.info("FishingOperation " + fishingOperation.getId() +
                         " was modified, will save it.");
            }

            showInformationMessage(
                    "[ Captures - Caractéristiques générales ] " +
                    "Sauvegarde des modifications de " + decorate(fishingOperation) +
                    ".");

            persistenceService.saveFishingOperation(fishingOperation);
        }

        ui.getSpeciesTabContent().getHandler().clearTableSelection();
        ui.getBenthosTabContent().getHandler().clearTableSelection();
        ui.getPlanktonTabContent().getHandler().clearTableSelection();
        ui.getMacroWasteTabContent().getHandler().clearTableSelection();
        ui.getAccidentalTabContent().getHandler().clearTableSelection();

        // 2) Use new selected fishingOperation

        boolean empty = bean == null;

        EditCatchesUIModel model = getModel();

        if (empty) {
            bean = new FishingOperation();
            model.setFishingOperation(null);
        } else {

            if (log.isInfoEnabled()) {
                log.info("Get species batch for fishingOperation: " +
                         bean.getId() + " - " + fishingOperationText);
            }

            model.setFishingOperation(bean);
        }

        model.fromBean(bean);

        fishingOperationMonitor.clearModified();

        // 3) Propagate title to others tabs

        ui.getCatchesCaracteristicsTabPane().setTitle(fishingOperationText);
        ui.getSpeciesTabFishingOperationReminderLabel().setTitle(fishingOperationText);
        ui.getBenthosTabFishingOperationReminderLabel().setTitle(fishingOperationText);
        ui.getPlanktonTabFishingOperationReminderLabel().setTitle(fishingOperationText);
        ui.getMacroWasteTabFishingOperationReminderLabel().setTitle(fishingOperationText);
        ui.getAccidentalTabFishingOperationReminderLabel().setTitle(fishingOperationText);

        // 4) Propagate new selected fishingoperation to others tabs

        ui.getSpeciesTabContent().getHandler().selectFishingOperation(bean);
        ui.getBenthosTabContent().getHandler().selectFishingOperation(bean);
        ui.getPlanktonTabContent().getHandler().selectFishingOperation(bean);
        ui.getMacroWasteTabContent().getHandler().selectFishingOperation(bean);
        ui.getAccidentalTabContent().getHandler().selectFishingOperation(bean);

        ui.getTabPane().repaint();
    }

    public void importPupitri() {
        //TODO
    }

}