/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.ReportExecutorUtil;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.area.IContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.LogicContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.PageArea;
import org.eclipse.birt.report.engine.layout.content.BlockStackingExecutor;
import org.eclipse.birt.report.engine.layout.pdf.PDFAbstractLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockContainerLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFRegionLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFReportLayoutEngine;

public class PDFPageLM
extends PDFBlockContainerLM
implements IBlockStackingLayoutManager {
    static final int DEFAULT_PAGE_WIDTH = 595275;
    static final int DEFAULT_PAGE_HEIGHT = 841889;
    protected PageArea page;
    protected IReportContent report;
    protected IPageContent pageContent;
    protected IReportExecutor reportExecutor = null;
    protected PDFReportLayoutEngine engine;
    protected IContentEmitter emitter;
    private int pageContentWidth = 595275;
    private int pageContentHeight = 841889;
    private int rootWidth;
    private int rootHeight;
    private int rootLeft;
    private int rootTop;

    public PDFPageLM(PDFReportLayoutEngine engine, PDFLayoutEngineContext context, IReportContent report, IContentEmitter emitter, IReportExecutor executor) {
        super(context, null, null, null);
        this.reportExecutor = executor;
        this.engine = engine;
        this.report = report;
        this.emitter = emitter;
    }

    @Override
    protected void initialize() throws BirtException {
        this.createRoot();
        this.context.setMaxHeight(this.page.getRoot().getHeight());
        this.context.setMaxWidth(this.page.getRoot().getWidth());
        this.layoutHeader();
        this.layoutFooter();
        this.updateBodySize(this.page);
        this.context.setMaxHeight(this.page.getBody().getHeight());
        this.context.setMaxWidth(this.page.getBody().getWidth());
        this.maxAvaWidth = this.context.getMaxWidth();
        this.maxAvaHeight = this.context.pagebreakPaginationOnly() ? Integer.MAX_VALUE : this.context.getMaxHeight();
        this.setCurrentIP(0);
        this.setCurrentBP(0);
    }

    protected void updateBodySize(PageArea page) {
        IContainerArea header = page.getHeader();
        ContainerArea footer = (ContainerArea)page.getFooter();
        ContainerArea body = (ContainerArea)page.getBody();
        ContainerArea root = (ContainerArea)page.getRoot();
        if (header != null && header.getHeight() >= root.getHeight()) {
            page.removeHeader();
            header = null;
        }
        if (footer != null && footer.getHeight() >= root.getHeight()) {
            page.removeHeader();
            footer = null;
        }
        if (header != null && footer != null && footer.getHeight() + header.getHeight() >= root.getHeight()) {
            page.removeFooter();
            page.removeHeader();
            header = null;
            footer = null;
        }
        body.setHeight(root.getHeight() - (header == null ? 0 : header.getHeight()) - (footer == null ? 0 : footer.getHeight()));
        body.setPosition(body.getX(), header == null ? 0 : header.getHeight());
        if (footer != null) {
            footer.setPosition(footer.getX(), (header == null ? 0 : header.getHeight()) + (body == null ? 0 : body.getHeight()));
        }
    }

    protected void layoutHeader() throws BirtException {
        IContent headerContent = this.pageContent.getPageHeader();
        DOMReportItemExecutor headerExecutor = new DOMReportItemExecutor(headerContent);
        headerExecutor.execute();
        PDFRegionLM regionLM = new PDFRegionLM(this.context, this.page.getHeader(), headerContent, (IReportItemExecutor)headerExecutor);
        boolean allowPB = this.context.allowPageBreak();
        this.context.setAllowPageBreak(false);
        regionLM.layout();
        this.context.setAllowPageBreak(allowPB);
    }

    protected void layoutFooter() throws BirtException {
        IContent footerContent = this.pageContent.getPageFooter();
        DOMReportItemExecutor footerExecutor = new DOMReportItemExecutor(footerContent);
        footerExecutor.execute();
        PDFRegionLM regionLM = new PDFRegionLM(this.context, this.page.getFooter(), footerContent, (IReportItemExecutor)footerExecutor);
        boolean allowPB = this.context.allowPageBreak();
        this.context.setAllowPageBreak(false);
        regionLM.layout();
        this.context.setAllowPageBreak(allowPB);
    }

    public void removeHeader() {
        this.page.removeHeader();
    }

    public void removeFooter() {
        this.page.removeFooter();
    }

    public void floatingFooter() {
        ContainerArea footer = (ContainerArea)this.page.getFooter();
        IContainerArea body = this.page.getBody();
        IContainerArea header = this.page.getHeader();
        if (footer != null) {
            footer.setPosition(footer.getX(), (header == null ? 0 : header.getHeight()) + (body == null ? 0 : body.getHeight()));
        }
    }

    @Override
    public boolean layout() throws BirtException {
        if (!this.context.isCancel()) {
            boolean childBreak = true;
            this.startPage();
            childBreak = this.layoutChildren();
            if (!childBreak) {
                this.isLast = true;
            }
            this.endPage();
            return childBreak;
        }
        this.cancel();
        return false;
    }

    protected void pageBreakEvent() {
        ILayoutPageHandler pageHandler = this.engine.getPageHandler();
        if (pageHandler != null) {
            pageHandler.onPage(this.context.getPageNumber(), this.context);
        }
    }

    protected void startPage() throws BirtException {
        MasterPageDesign pageDesign = this.getMasterPage(this.report);
        this.pageContent = ReportExecutorUtil.executeMasterPage(this.reportExecutor, this.context.getPageNumber(), pageDesign);
        this.content = this.pageContent;
    }

    protected void endPage() throws BirtException {
        MasterPageDesign mp;
        if (this.context.isAutoPageBreak()) {
            this.context.setAutoPageBreak(false);
            this.autoPageBreak();
        }
        if (this.isPageEmpty()) {
            if (!this.isFirst) {
                if (this.isLast) {
                    this.context.setPageNumber(this.context.getPageNumber() - 1L);
                    this.context.setPageCount(this.context.getPageCount() - 1L);
                }
                return;
            }
            if (!this.isLast) {
                return;
            }
        }
        if ((mp = this.getMasterPage(this.report)) instanceof SimpleMasterPageDesign) {
            if (this.isFirst && !((SimpleMasterPageDesign)mp).isShowHeaderOnFirst()) {
                this.removeHeader();
                this.isFirst = false;
            }
            if (this.isLast && !((SimpleMasterPageDesign)mp).isShowFooterOnLast()) {
                this.removeFooter();
            }
            if (((SimpleMasterPageDesign)mp).isFloatingFooter()) {
                this.floatingFooter();
            }
        }
        if (this.isFirst) {
            this.isFirst = false;
        }
        this.emitter.startPage(this.pageContent);
        this.emitter.endPage(this.pageContent);
        this.pageBreakEvent();
        if (!this.isLast) {
            this.context.setPageNumber(this.context.getPageNumber() + 1L);
            this.context.setPageCount(this.context.getPageCount() + 1L);
        }
    }

    @Override
    public boolean isPageEmpty() {
        IContainerArea body;
        return this.page == null || (body = this.page.getBody()).getChildrenCount() <= 0;
    }

    @Override
    protected void createRoot() {
        this.root = new PageArea(this.pageContent);
        this.page = (PageArea)this.root;
        int overFlowType = this.context.getPageOverflow();
        if (overFlowType == 4) {
            this.page.setExtendToMultiplePages(true);
        }
        this.pageContentWidth = this.getDimensionValue(this.pageContent.getPageWidth());
        this.pageContentHeight = this.getDimensionValue(this.pageContent.getPageHeight());
        if (this.pageContentWidth <= 0) {
            this.pageContentWidth = 595275;
        }
        if (this.pageContentHeight <= 0) {
            this.pageContentHeight = 841889;
        }
        this.page.setWidth(this.pageContentWidth);
        this.page.setHeight(this.pageContentHeight);
        LogicContainerArea pageRoot = new LogicContainerArea(this.report);
        this.rootLeft = this.getDimensionValue(this.pageContent.getMarginLeft(), this.pageContentWidth);
        this.rootTop = this.getDimensionValue(this.pageContent.getMarginTop(), this.pageContentWidth);
        this.rootLeft = Math.max(0, this.rootLeft);
        this.rootLeft = Math.min(this.pageContentWidth, this.rootLeft);
        this.rootTop = Math.max(0, this.rootTop);
        this.rootTop = Math.min(this.pageContentHeight, this.rootTop);
        pageRoot.setPosition(this.rootLeft, this.rootTop);
        int rootRight = this.getDimensionValue(this.pageContent.getMarginRight(), this.pageContentWidth);
        int rootBottom = this.getDimensionValue(this.pageContent.getMarginBottom(), this.pageContentWidth);
        rootRight = Math.max(0, rootRight);
        rootBottom = Math.max(0, rootBottom);
        if (this.rootLeft + rootRight > this.pageContentWidth) {
            rootRight = 0;
        }
        if (this.rootTop + rootBottom > this.pageContentHeight) {
            rootBottom = 0;
        }
        this.rootWidth = this.pageContentWidth - this.rootLeft - rootRight;
        this.rootHeight = this.pageContentHeight - this.rootTop - rootBottom;
        pageRoot.setWidth(this.rootWidth);
        pageRoot.setHeight(this.rootHeight);
        this.page.setRoot(pageRoot);
        int headerHeight = this.getDimensionValue(this.pageContent.getHeaderHeight(), pageRoot.getHeight());
        int headerWidth = pageRoot.getWidth();
        headerHeight = Math.max(0, headerHeight);
        headerHeight = Math.min(pageRoot.getHeight(), headerHeight);
        LogicContainerArea header = new LogicContainerArea(this.report);
        header.setHeight(headerHeight);
        header.setWidth(headerWidth);
        header.setPosition(0, 0);
        pageRoot.addChild(header);
        this.page.setHeader(header);
        int footerHeight = this.getDimensionValue(this.pageContent.getFooterHeight(), pageRoot.getHeight());
        int footerWidth = pageRoot.getWidth();
        footerHeight = Math.max(0, footerHeight);
        footerHeight = Math.min(pageRoot.getHeight() - headerHeight, footerHeight);
        LogicContainerArea footer = new LogicContainerArea(this.report);
        footer.setHeight(footerHeight);
        footer.setWidth(footerWidth);
        footer.setPosition(0, pageRoot.getHeight() - footerHeight);
        pageRoot.addChild(footer);
        this.page.setFooter(footer);
        LogicContainerArea body = new LogicContainerArea(this.report);
        int bodyLeft = this.getDimensionValue(this.pageContent.getLeftWidth(), pageRoot.getWidth());
        bodyLeft = Math.max(0, bodyLeft);
        bodyLeft = Math.min(pageRoot.getWidth(), bodyLeft);
        body.setPosition(bodyLeft, headerHeight);
        int bodyRight = this.getDimensionValue(this.pageContent.getRightWidth(), pageRoot.getWidth());
        bodyRight = Math.max(0, bodyRight);
        bodyRight = Math.min(pageRoot.getWidth() - bodyLeft, bodyRight);
        body.setWidth(pageRoot.getWidth() - bodyLeft - bodyRight);
        body.setHeight(pageRoot.getHeight() - headerHeight - footerHeight);
        this.page.setBody(body);
        pageRoot.addChild(body);
        if (overFlowType == 1) {
            pageRoot.setNeedClip(true);
            this.page.getBody().setNeedClip(true);
        } else {
            pageRoot.setNeedClip(false);
        }
    }

    @Override
    protected IReportItemExecutor createExecutor() {
        return new BlockStackingExecutor(this.content, new PDFAbstractLM.ReportStackingExecutor(this.reportExecutor));
    }

    @Override
    protected void closeLayout() {
        int overFlowType = this.context.getPageOverflow();
        if (overFlowType == 2) {
            float scale = this.calculatePageScale();
            if (1.0f == scale) {
                return;
            }
            this.page.setScale(scale);
            this.updatePageDimension(scale);
        } else if (overFlowType == 8) {
            float scale = this.calculatePageScale();
            if (1.0f == scale) {
                return;
            }
            this.updatePageDimension(scale);
        }
    }

    private float calculatePageScale() {
        float scale = 1.0f;
        if (this.page != null && this.page.getRoot().getChildrenCount() > 0) {
            int maxWidth = this.context.getMaxWidth();
            int maxHeight = this.context.getMaxHeight();
            int prefWidth = this.context.getPreferenceWidth();
            int prefHeight = this.getCurrentBP();
            Iterator iter = this.page.getBody().getChildren();
            while (iter.hasNext()) {
                AbstractArea area = (AbstractArea)iter.next();
                prefWidth = Math.max(prefWidth, area.getAllocatedWidth());
            }
            if (prefHeight > maxHeight) {
                ((ContainerArea)this.page.getBody()).setHeight(prefHeight);
                this.floatingFooter();
            }
            if (prefWidth > maxWidth || prefHeight > maxHeight) {
                scale = Math.min((float)maxWidth / (float)prefWidth, (float)maxHeight / (float)prefHeight);
            }
        }
        return scale;
    }

    protected void updatePageDimension(float scale) {
        this.page.setHeight((int)((float)this.pageContentHeight / scale));
        this.page.setWidth((int)((float)this.pageContentWidth / scale));
        ContainerArea pageRoot = (ContainerArea)this.page.getRoot();
        pageRoot.setPosition((int)((float)this.rootLeft / scale), (int)((float)this.rootTop / scale));
        pageRoot.setHeight((int)((float)this.rootHeight / scale));
        pageRoot.setWidth((int)((float)this.rootWidth / scale));
    }

    @Override
    protected boolean addToRoot(AbstractArea area) {
        this.root.addChild(area);
        area.setAllocatedPosition(this.currentIP + this.offsetX, this.currentBP + this.offsetY);
        this.currentBP += area.getAllocatedHeight();
        assert (this.root instanceof PageArea);
        AbstractArea body = (AbstractArea)((Object)((PageArea)this.root).getBody());
        if (this.currentIP + area.getAllocatedWidth() > this.root.getContentWidth() - body.getX()) {
            this.root.setNeedClip(true);
        }
        if (this.currentBP > this.maxAvaHeight) {
            this.root.setNeedClip(true);
        }
        return true;
    }

    @Override
    protected boolean isRootEmpty() {
        IContainerArea body;
        return this.page == null || (body = this.page.getBody()).getChildrenCount() <= 0 && (!this.isFirst || !this.isLast);
    }
}

