/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.report.data.adapter.api.IColumnValueIterator;
import org.eclipse.birt.report.data.adapter.api.IRequestInfo;

public class ColumnValueIterator
implements IColumnValueIterator {
    private IResultIterator resultIterator;
    private String boundColumnName;
    private IQueryResults queryResults;
    private Object value;
    private Set visitedValues;
    private int startRow;
    private int maxRows = 10000;

    ColumnValueIterator(IQueryResults queryResults, String boundColumnName, IRequestInfo requestInfo) throws BirtException {
        this.queryResults = queryResults;
        this.boundColumnName = boundColumnName;
        this.visitedValues = new HashSet();
        if (requestInfo != null) {
            this.startRow = requestInfo.getStartRow();
            this.maxRows = requestInfo.getMaxRow();
        }
        this.moveTo(this.startRow);
    }

    @Override
    public boolean next() throws BirtException {
        if (this.visitedValues.size() > this.maxRows) {
            return false;
        }
        if (this.resultIterator == null) {
            if (this.queryResults == null) {
                return false;
            }
            this.resultIterator = this.queryResults.getResultIterator();
        }
        if (this.resultIterator == null || !this.resultIterator.next()) {
            return false;
        }
        this.value = this.resultIterator.getValue(this.boundColumnName);
        while (this.visitedValues.contains(this.value)) {
            boolean hasNext = this.resultIterator.next();
            if (hasNext) {
                this.value = this.resultIterator.getValue(this.boundColumnName);
                continue;
            }
            return false;
        }
        this.visitedValues.add(this.value);
        return true;
    }

    @Override
    public Object getValue() throws BirtException {
        return this.value;
    }

    @Override
    public void close() throws BirtException {
        if (this.resultIterator != null) {
            this.resultIterator.close();
        }
        if (this.queryResults != null) {
            this.queryResults.close();
        }
    }

    private void moveTo(int rowIndex) throws BirtException {
        if (this.resultIterator == null) {
            if (this.queryResults == null) {
                return;
            }
            this.resultIterator = this.queryResults.getResultIterator();
        }
        if (this.resultIterator == null || this.resultIterator.isEmpty()) {
            return;
        }
        this.resultIterator.moveTo(rowIndex);
        this.value = this.resultIterator.getValue(this.boundColumnName);
        this.visitedValues.add(this.value);
    }
}

