/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.NumberFormatValue;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.w3c.dom.css.CSSValue;

public class StyleBuilder {
    public static final String C_PATTERN = "(rgb\\()(\\d+)\\,(\\s?\\d+)\\,(\\s?\\d+)\\)";
    public static final Pattern colorp = Pattern.compile("(rgb\\()(\\d+)\\,(\\s?\\d+)\\,(\\s?\\d+)\\)", 2);
    private static Logger logger = Logger.getLogger(StyleBuilder.class.getName());

    public static StyleEntry createStyleEntry(IStyle style) {
        return StyleBuilder.createStyleEntry(style, null);
    }

    public static StyleEntry createStyleEntry(IStyle style, StyleEntry parent) {
        StyleEntry entry = new StyleEntry();
        StyleBuilder.populateColor(style, 8, entry, 6);
        CSSValue borderWidth = style.getProperty(11);
        int width = PropertyUtil.getDimensionValue(borderWidth);
        if (width > 0) {
            StyleBuilder.populateColor(style, 15, entry, 10);
            entry.setProperty(11, StyleBuilder.convertBorderStyle(style.getBorderBottomStyle()));
            entry.setProperty(12, StyleBuilder.convertBorderWeight(width));
        }
        if ((width = PropertyUtil.getDimensionValue(borderWidth = style.getProperty(41))) > 0) {
            StyleBuilder.populateColor(style, 13, entry, 13);
            entry.setProperty(14, StyleBuilder.convertBorderStyle(style.getBorderTopStyle()));
            entry.setProperty(15, StyleBuilder.convertBorderWeight(width));
        }
        if ((width = PropertyUtil.getDimensionValue(borderWidth = style.getProperty(42))) > 0) {
            StyleBuilder.populateColor(style, 46, entry, 16);
            entry.setProperty(17, StyleBuilder.convertBorderStyle(style.getBorderLeftStyle()));
            entry.setProperty(18, StyleBuilder.convertBorderWeight(width));
        }
        if ((width = PropertyUtil.getDimensionValue(borderWidth = style.getProperty(10))) > 0) {
            StyleBuilder.populateColor(style, 14, entry, 19);
            entry.setProperty(20, StyleBuilder.convertBorderStyle(style.getBorderRightStyle()));
            entry.setProperty(21, StyleBuilder.convertBorderWeight(width));
        }
        StyleBuilder.populateColor(style, 0, entry, 7);
        entry.setProperty(0, ExcelUtil.getValue(style.getFontFamily()));
        entry.setProperty(1, Float.valueOf(StyleBuilder.convertFontSize(style.getProperty(39))));
        entry.setProperty(2, "italic".equalsIgnoreCase(style.getFontStyle()) || "oblique".equalsIgnoreCase(style.getFontStyle()));
        entry.setProperty(3, "bold".equalsIgnoreCase(style.getFontWeight()));
        entry.setProperty(4, "line-through".equalsIgnoreCase(style.getTextLineThrough()));
        entry.setProperty(5, "underline".equalsIgnoreCase(style.getTextUnderline()));
        entry.setProperty(8, StyleBuilder.convertHAlign(style.getTextAlign(), style.getDirection()));
        entry.setProperty(9, StyleBuilder.convertVAlign(parent, style.getVerticalAlign()));
        entry.setProperty(22, style.getDateFormat());
        String format = style.getNumberFormat();
        entry.setProperty(23, NumberFormatValue.getInstance(format));
        entry.setProperty(24, style.getStringFormat());
        entry.setProperty(26, style.getTextTransform());
        entry.setProperty(27, style.getProperty(20));
        entry.setProperty(28, style.getDirection());
        entry.setProperty(29, style.getWhiteSpace());
        return entry;
    }

    public static StyleEntry createEmptyStyleEntry() {
        StyleEntry entry = new StyleEntry();
        return entry;
    }

    public static StyleEntry applyDiagonalLine(StyleEntry entry, Color color, String style, int width) {
        if (width > 0) {
            entry.setProperty(30, color);
            entry.setProperty(31, StyleBuilder.convertBorderStyle(style));
            entry.setProperty(32, StyleBuilder.convertBorderWeight(width));
        }
        return entry;
    }

    private static void populateColor(IStyle style, int styleIndex, StyleEntry entry, int index) {
        CSSValue value = style.getProperty(styleIndex);
        entry.setProperty(index, PropertyUtil.getColor(value));
    }

    public static float convertFontSize(CSSValue fontSize) {
        int size = PropertyUtil.getDimensionValue(fontSize);
        float fsize = 0.0f;
        try {
            fsize = (float)size / 1000.0f;
        }
        catch (NumberFormatException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return fsize;
    }

    public static int convertBorderWeight(int width) {
        int w = -1;
        w = width <= 750 ? 1 : (width >= 750 && width <= 2250 ? 2 : (width > 2250 ? 3 : 2));
        return w;
    }

    public static String convertBorderStyle(String style) {
        String bs = ExcelUtil.getValue(style);
        if (!StyleEntry.isNull(bs)) {
            bs = "dotted".equalsIgnoreCase(bs) ? "Dot" : ("dashed".equalsIgnoreCase(bs) ? "Dash" : ("double".equalsIgnoreCase(bs) ? "Double" : "Continuous"));
        }
        return bs;
    }

    public static String convertHAlign(String align, String direction) {
        String ha = null;
        ha = "left".equalsIgnoreCase(align = ExcelUtil.getValue(align)) ? "Left" : ("right".equalsIgnoreCase(align) ? "Right" : ("center".equalsIgnoreCase(align) ? "Center" : ("rtl".equalsIgnoreCase(direction) ? "Right" : "Left")));
        return ha;
    }

    public static String convertVAlign(StyleEntry parent, String align) {
        if ("bottom".equalsIgnoreCase(align = ExcelUtil.getValue(align))) {
            return "Bottom";
        }
        if ("middle".equalsIgnoreCase(align)) {
            return "Center";
        }
        if ("baseline".equalsIgnoreCase(align) && parent != null) {
            return (String)parent.getProperty(9);
        }
        return "Top";
    }

    public static boolean isHeritable(int id) {
        return (id < 10 || id > 21) && (id < 30 || id > 35);
    }

    public static void mergeInheritableProp(StyleEntry cEntry, StyleEntry entry) {
        int i = 0;
        while (i < 36) {
            if (StyleBuilder.isHeritable(i) && StyleEntry.isNull(entry.getProperty(i))) {
                entry.setProperty(i, cEntry.getProperty(i));
            }
            ++i;
        }
    }

    public static void applyRightBorder(StyleEntry cEntry, StyleEntry entry) {
        if (entry == null) {
            return;
        }
        StyleBuilder.overwriteProp(cEntry, entry, 19);
        StyleBuilder.overwriteProp(cEntry, entry, 20);
        StyleBuilder.overwriteProp(cEntry, entry, 21);
    }

    public static void applyLeftBorder(StyleEntry cEntry, StyleEntry entry) {
        if (entry == null) {
            return;
        }
        StyleBuilder.overwriteProp(cEntry, entry, 16);
        StyleBuilder.overwriteProp(cEntry, entry, 17);
        StyleBuilder.overwriteProp(cEntry, entry, 18);
    }

    public static void applyTopBorder(StyleEntry cEntry, StyleEntry entry) {
        if (entry == null) {
            return;
        }
        StyleBuilder.overwriteProp(cEntry, entry, 13);
        StyleBuilder.overwriteProp(cEntry, entry, 14);
        StyleBuilder.overwriteProp(cEntry, entry, 15);
    }

    public static boolean applyBottomBorder(StyleEntry cEntry, StyleEntry entry) {
        if (entry == null) {
            return false;
        }
        boolean isChanged = false;
        isChanged |= StyleBuilder.overwriteProp(cEntry, entry, 10);
        isChanged |= StyleBuilder.overwriteProp(cEntry, entry, 11);
        return isChanged |= StyleBuilder.overwriteProp(cEntry, entry, 12);
    }

    private static boolean overwriteProp(StyleEntry cEntry, StyleEntry entry, int id) {
        if (StyleEntry.isNull(entry.getProperty(id))) {
            Object property = cEntry.getProperty(id);
            if (property != null) {
                entry.setProperty(id, property);
                return true;
            }
            return false;
        }
        return false;
    }
}

