/*
 * *##% 
 * SuiviObsmer :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package fr.ifremer.suiviobsmer.ui.pages;

import fr.ifremer.suiviobsmer.SuiviObsmerBusinessException;
import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.entity.User;
import fr.ifremer.suiviobsmer.services.ServiceUser;
import fr.ifremer.suiviobsmer.ui.base.SuiviObsmerPage;
import fr.ifremer.suiviobsmer.ui.components.Layout;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.BeanEditForm;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.slf4j.Logger;

/**
 * UserProfile
 *
 * Created: 10 nov. 2009
 *
 * @author fdesbois
 * @version $Revision: 186 $
 *
 * Mise a jour: $Date: 2010-01-12 15:57:02 +0100 (mar., 12 janv. 2010) $
 * par : $Author: fdesbois $
 */
@IncludeStylesheet("context:css/userProfile.css")
public class UserProfile implements SuiviObsmerPage {

    @Override
    public boolean isOnlyForAdmin() {
        return false;
    }

    @Inject
    private Logger log;

    @Inject
    private ServiceUser serviceUser;

    @InjectComponent
    private Layout layout;

    @SessionState
    private User user;
    
    private User userEditable;

    @InjectComponent
    private BeanEditForm userForm;

    @Property
    private String password;

    @Property
    private String password2;

    public User getUserEditable() {
        if (userEditable == null) {
            userEditable = user;
        }
        return userEditable;
    }

    void onSuccessFromUserForm() throws SuiviObsmerException {

        if (password != null && !password.equals(password2)) {
            userForm.recordError("Les deux password ne sont pas identiques, vérifiez la saisie !");
        } else {
            try {
                if (!StringUtils.isEmpty(password)) {
                    userEditable.setPassword(password);
                    userEditable.setPasswordChanged(true);
                }
                serviceUser.createUpdateUser(userEditable, false);
                layout.getFeedBack().addInfo("Modifications enregistrées avec succès !");
            } catch (SuiviObsmerBusinessException eee) {
                userForm.recordError(eee.getMessage());
//                if (log.isErrorEnabled()) {
//                    log.error("Error during user save", eee);
//                }
            }
        }
    }


        
}
