/*
 * *##% 
 * SuiviObsmer :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package fr.ifremer.suiviobsmer.ui.pages;

import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.entity.News;
import fr.ifremer.suiviobsmer.entity.NewsImpl;
import fr.ifremer.suiviobsmer.entity.User;
import fr.ifremer.suiviobsmer.services.ServiceNews;
import fr.ifremer.suiviobsmer.ui.base.SuiviObsmerPage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry5.Asset2;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.slf4j.Logger;

/**
 * Index
 *
 * Created: 9 nov. 2009
 *
 * @author fdesbois
 * @version $Revision: 220 $
 *
 * Mise a jour: $Date: 2010-01-17 20:32:26 +0100 (dim. 17 janv. 2010) $
 * par : $Author: fdesbois $
 */
@IncludeStylesheet("context:css/news.css")
public class Index implements SuiviObsmerPage {

    @Override
    public boolean isOnlyForAdmin() {
        return false;
    }

    @Inject
    private ServiceNews serviceNews;

    @Inject
    private Logger log;

    @SessionState
    @Property
    private User user;

    @Persist
    private List<News> newsList;

    @Property
    private News news;

    private DateFormat dateFormat;

    @Persist("flash")
    private String editedId;

    @Property
    private int rowIndex;

    @Property
    @Inject
    @Path("context:js/FCKConf.js")
    private Asset2 fckconf;


    @Log
    void setupRender() throws SuiviObsmerException {
        if (editedId == null || !"NEW".equals(editedId)) {
            newsList = null;
            getNewsList();
        }
    }

//    void onActivate(EventContext ec) {
//        if (ec.getCount() > 0) {
//            this.editedId = ec.get(String.class, 0);
//        }
//    }
//
//    String onPassivate() {
//        return editedId;
//    }

    public List<News> getNewsList() throws SuiviObsmerException {
        if (newsList == null) {
            newsList = serviceNews.getNews();
        }
        return newsList;
    }

    public boolean isEditionMode() {
        return isCreateMode() || news.getTopiaId().equals(editedId);
    }

    public boolean isCreateMode() {
        return news.getTopiaId() == null;
    }

    public DateFormat getDateFormat() {
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        }
        return dateFormat;
    }

    void onActionFromAddNews() throws SuiviObsmerException {
        news = new NewsImpl();
        // Create a new list with the new news in first position
        List<News> list = new ArrayList<News>();
        list.add(news);
        list.addAll(getNewsList());
        newsList = list;
        editedId = "NEW";
    }

    void onActionFromEditNews(int rowIndex) throws SuiviObsmerException {
        news = getNewsList().get(rowIndex);
        this.editedId = news.getTopiaId();
    }

    void onActionFromDeleteNews(int rowIndex) throws SuiviObsmerException {
        news = getNewsList().get(rowIndex);
        serviceNews.saveNews(news, true);
        //newsList = null;
    }

    void onActionFromCancelEdit() {
    }

    void onSelectedFromSaveNews(int rowIndex) throws SuiviObsmerException {
        news = getNewsList().get(rowIndex);
    }

    void onSuccessFromNewsForm() throws SuiviObsmerException {
        serviceNews.saveNews(news, false);
        //this.editedId = null;
        if (log.isDebugEnabled()) {
            log.debug(news.getContent());
        }
    }
        
}
