/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.fisheryregion;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.CellDAO;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.input.check.CheckRegion;
import fr.ifremer.isisfish.ui.input.check.CheckResult;
import fr.ifremer.isisfish.ui.input.check.CheckResultFrame;
import fr.ifremer.isisfish.ui.input.fisheryregion.FisheryRegionUI;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import fr.ifremer.isisfish.util.CellPointcomparator;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.util.FileUtil;

public class FisheryRegionHandler
extends InputContentHandler<FisheryRegionUI> {
    private static final Log log = LogFactory.getLog(FisheryRegionHandler.class);

    protected FisheryRegionHandler(FisheryRegionUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((FisheryRegionUI)this.inputContentUI).setButtonTitle(I18n.t((String)"isisfish.input.continueCells", (Object[])new Object[0]));
        ((FisheryRegionUI)this.inputContentUI).setNextPath(I18n.n((String)"isisfish.input.tree.cells", (Object[])new Object[0]));
        ((FisheryRegionUI)this.inputContentUI).addPropertyChangeListener("bean", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    // empty if block
                }
                if (evt.getNewValue() != null) {
                    FisheryRegionHandler.this.setFieldMapfilesModel(((FisheryRegionUI)FisheryRegionHandler.this.inputContentUI).getBean());
                }
            }
        });
    }

    public void refresh() {
        FisheryRegion region = ((FisheryRegionUI)this.inputContentUI).getSaveVerifier().getEntity(FisheryRegion.class);
        ((FisheryRegionUI)this.inputContentUI).setBean((FisheryRegion)null);
        ((FisheryRegionUI)this.inputContentUI).setBean(region);
    }

    protected void setFieldMapfilesModel(FisheryRegion region) {
        DefaultListModel<String> model = new DefaultListModel<String>();
        List<String> mapList = region.getMapFileList();
        if (mapList != null) {
            int cnt = 0;
            for (String map : mapList) {
                model.add(cnt, map);
                ++cnt;
            }
        }
        ((FisheryRegionUI)this.inputContentUI).fieldMapfiles.setModel(model);
    }

    protected void addMap() {
        this.addMap(((FisheryRegionUI)this.inputContentUI).getBean());
        this.setFieldMapfilesModel(((FisheryRegionUI)this.inputContentUI).getBean());
    }

    protected void delMap() {
        this.removeMap(((FisheryRegionUI)this.inputContentUI).getBean(), ((FisheryRegionUI)this.inputContentUI).fieldMapfiles.getSelectedValuesList());
        this.setFieldMapfilesModel(((FisheryRegionUI)this.inputContentUI).getBean());
    }

    public void addMap(FisheryRegion fisheryRegion) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"AddMap called");
        }
        String[] fileFormats = new String[]{".*\\.shp", "ESRI Shapefiles (.shp)", ".*\\.dcw", "Digital Chart of the World (.dcw)", ".*\\.vpf", "Vector Product Format (.vpf)", ".*\\.vmap", "Vector Map (.vmap)", ".*\\.cadrg", "Compressed ARC Digitized Raster Graphics (.cadrg)", ".*\\.cib", "Controlled Image Base (.cib)", ".*\\.rpf", "Raster Product Format (.rpf)", ".*\\.mif", "MapInfo (.mif)", ".*\\.e00", "ArcInfo (.e00)"};
        File inputMap = FileUtil.getFile((String[])fileFormats);
        try {
            if (inputMap != null) {
                String filename = inputMap.getName();
                RegionStorage regionStorage = RegionStorage.getRegion(fisheryRegion.getName());
                File destDir = regionStorage.getMapRepository();
                File destMap = new File(destDir, filename);
                FileUtils.copyFile((File)inputMap, (File)destMap);
                List<String> maps = fisheryRegion.getMapFileList();
                maps.add(filename);
                fisheryRegion.setMapFileList(maps);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't copy map file for : " + inputMap), (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.region.addmap", (Object[])new Object[0]), eee);
        }
    }

    public void removeMap(FisheryRegion fisheryRegion, List<String> selectedMaps) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"removeMap called");
        }
        try {
            List<String> maps = fisheryRegion.getMapFileList();
            RegionStorage regionStorage = RegionStorage.getRegion(fisheryRegion.getName());
            File mapDir = regionStorage.getMapRepository();
            for (String mapName : selectedMaps) {
                maps.remove(mapName);
                File mapFile = new File(mapDir, mapName);
                mapFile.delete();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing map file : " + mapFile));
                }
                if (!mapName.endsWith(".shp")) continue;
                String indexName = mapName.replaceAll("\\.shp$", ".ssx");
                File indexFile = new File(mapDir, indexName);
                indexFile.delete();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Removing index file : " + indexFile));
            }
            fisheryRegion.setMapFileList(maps);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove map", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.region.removemap", (Object[])new Object[0]), eee);
        }
    }

    protected void check() {
        this.checkFisheryRegion(((FisheryRegionUI)this.inputContentUI).getBean());
        ((FisheryRegionUI)this.inputContentUI).setInfoText(I18n.t((String)"isisfish.message.check.finished", (Object[])new Object[0]));
    }

    public void checkFisheryRegion(FisheryRegion fisheryRegion) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)"check called: ");
            }
            CheckResult result = new CheckResult();
            CheckRegion.check(fisheryRegion, result);
            CheckResultFrame dialog = new CheckResultFrame();
            dialog.setCheckResult(result);
            dialog.setLocationByPlatform(true);
            dialog.setVisible(true);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n.t((String)"isisfish.error.region.check", (Object[])new Object[0]), (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.region.check", (Object[])new Object[0]), eee);
        }
    }

    protected void save() {
        ((FisheryRegionUI)this.inputContentUI).setInfoText(I18n.t((String)"isisfish.message.checking.cell", (Object[])new Object[0]));
        ((FisheryRegionUI)this.inputContentUI).getSaveVerifier().reset();
        this.saveFisheryRegion(((FisheryRegionUI)this.inputContentUI).getBean());
        InputUI inputUI = ((FisheryRegionUI)this.inputContentUI).getParentContainer(InputUI.class);
        inputUI.getHandler().reloadFisheryTree();
        ((FisheryRegionUI)this.inputContentUI).setInfoText(I18n.t((String)"isisfish.message.save.finished", (Object[])new Object[0]));
    }

    public void saveFisheryRegion(FisheryRegion fisheryRegion) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"save called");
        }
        try {
            TopiaContext isisContext = fisheryRegion.getTopiaContext();
            int latNumber = Math.round((fisheryRegion.getMaxLatitude() - fisheryRegion.getMinLatitude()) / fisheryRegion.getCellLengthLatitude());
            int lonNumber = Math.round((fisheryRegion.getMaxLongitude() - fisheryRegion.getMinLongitude()) / fisheryRegion.getCellLengthLongitude());
            boolean progresscpt = false;
            CellPointcomparator cellPointcomparator = new CellPointcomparator();
            CellDAO cellPS = IsisFishDAOHelper.getCellDAO(isisContext);
            List cells = cellPS.findAll();
            Collections.sort(cells, cellPointcomparator);
            Point2D.Float point = new Point2D.Float();
            for (float lati = fisheryRegion.getMinLatitude(); lati < fisheryRegion.getMaxLatitude(); lati += fisheryRegion.getCellLengthLatitude()) {
                lati = Math.round(lati * 1000.0f);
                lati /= 1000.0f;
                for (float longi = fisheryRegion.getMinLongitude(); longi < fisheryRegion.getMaxLongitude(); longi += fisheryRegion.getCellLengthLongitude()) {
                    longi = (float)Math.round(longi * 1000.0f) / 1000.0f;
                    point.setLocation(lati, longi);
                    int position = Collections.binarySearch(cells, point, cellPointcomparator);
                    if (position >= 0) {
                        cells.remove(position);
                        continue;
                    }
                    Cell cell = (Cell)cellPS.create(new Object[0]);
                    cell.setName("La" + lati + "Lo" + longi);
                    cell.setLatitude(lati);
                    cell.setLongitude(longi);
                    cell.setLand(false);
                    cell.update();
                }
            }
            fisheryRegion.update();
            progresscpt = false;
            for (Cell cell : cells) {
                cellPS.delete(cell);
            }
            isisContext.commitTransaction();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n.t((String)"isisfish.error.region.save", (Object[])new Object[0]), (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.region.save", (Object[])new Object[0]), eee);
        }
    }
}

