/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.TargetSpecies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class SpeciesAbstract
extends TopiaEntityAbstract
implements Species {
    protected String name;
    protected String scientificName;
    protected String codeRubbin;
    protected int codeCEE;
    protected boolean ageGroupType;
    protected String comment;
    protected Collection<TargetSpecies> metierSeasonInfoTargetSpecies;
    protected Collection<Population> population;
    private static final long serialVersionUID = 4064048070971962679L;

    public void update() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Species.class).update((TopiaEntity)this);
    }

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Species.class).delete((TopiaEntity)this);
    }

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        this.accept0(visitor);
        visitor.end((TopiaEntity)this);
    }

    protected void accept0(EntityVisitor visitor) throws TopiaException {
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "scientificName", String.class, (Object)this.scientificName);
        visitor.visit((TopiaEntity)this, "codeRubbin", String.class, (Object)this.codeRubbin);
        visitor.visit((TopiaEntity)this, "codeCEE", Integer.TYPE, (Object)this.codeCEE);
        visitor.visit((TopiaEntity)this, "ageGroupType", Boolean.TYPE, (Object)this.ageGroupType);
        visitor.visit((TopiaEntity)this, "comment", String.class, (Object)this.comment);
        visitor.visit((TopiaEntity)this, "metierSeasonInfoTargetSpecies", Collection.class, TargetSpecies.class, this.metierSeasonInfoTargetSpecies);
        visitor.visit((TopiaEntity)this, "population", Collection.class, Population.class, this.population);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        this.fireOnPreWrite("name", oldValue, name);
        this.name = name;
        this.fireOnPostWrite("name", oldValue, name);
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void setScientificName(String scientificName) {
        String oldValue = this.scientificName;
        this.fireOnPreWrite("scientificName", oldValue, scientificName);
        this.scientificName = scientificName;
        this.fireOnPostWrite("scientificName", oldValue, scientificName);
    }

    @Override
    public String getScientificName() {
        String result = this.scientificName;
        return result;
    }

    @Override
    public void setCodeRubbin(String codeRubbin) {
        String oldValue = this.codeRubbin;
        this.fireOnPreWrite("codeRubbin", oldValue, codeRubbin);
        this.codeRubbin = codeRubbin;
        this.fireOnPostWrite("codeRubbin", oldValue, codeRubbin);
    }

    @Override
    public String getCodeRubbin() {
        String result = this.codeRubbin;
        return result;
    }

    @Override
    public void setCodeCEE(int codeCEE) {
        int oldValue = this.codeCEE;
        this.fireOnPreWrite("codeCEE", oldValue, codeCEE);
        this.codeCEE = codeCEE;
        this.fireOnPostWrite("codeCEE", oldValue, codeCEE);
    }

    @Override
    public int getCodeCEE() {
        int result = this.codeCEE;
        return result;
    }

    @Override
    public void setAgeGroupType(boolean ageGroupType) {
        boolean oldValue = this.ageGroupType;
        this.fireOnPreWrite("ageGroupType", oldValue, ageGroupType);
        this.ageGroupType = ageGroupType;
        this.fireOnPostWrite("ageGroupType", oldValue, ageGroupType);
    }

    @Override
    public boolean isAgeGroupType() {
        boolean result = this.ageGroupType;
        return result;
    }

    @Override
    public boolean getAgeGroupType() {
        boolean result = this.ageGroupType;
        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        this.fireOnPreWrite("comment", oldValue, comment);
        this.comment = comment;
        this.fireOnPostWrite("comment", oldValue, comment);
    }

    @Override
    public String getComment() {
        String result = this.comment;
        return result;
    }

    @Override
    public void addPopulation(Population population) {
        this.fireOnPreWrite("population", null, population);
        if (this.population == null) {
            this.population = new ArrayList<Population>();
        }
        population.setSpecies(this);
        this.population.add(population);
        this.fireOnPostWrite("population", this.population.size(), null, population);
    }

    @Override
    public void addAllPopulation(Collection<Population> population) {
        if (population == null) {
            return;
        }
        for (Population item : population) {
            this.addPopulation(item);
        }
    }

    @Override
    public void setPopulation(Collection<Population> population) {
        ArrayList<Population> oldValue = this.population != null ? new ArrayList<Population>(this.population) : null;
        this.fireOnPreWrite("population", oldValue, population);
        this.population = population;
        this.fireOnPostWrite("population", oldValue, population);
    }

    @Override
    public void removePopulation(Population population) {
        this.fireOnPreWrite("population", population, null);
        if (this.population == null || !this.population.remove(population)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        population.setSpecies(null);
        this.fireOnPostWrite("population", this.population.size() + 1, population, null);
    }

    @Override
    public void clearPopulation() {
        if (this.population == null) {
            return;
        }
        for (Population item : this.population) {
            item.setSpecies(null);
        }
        ArrayList<Population> oldValue = new ArrayList<Population>(this.population);
        this.fireOnPreWrite("population", oldValue, this.population);
        this.population.clear();
        this.fireOnPostWrite("population", oldValue, this.population);
    }

    @Override
    public Collection<Population> getPopulation() {
        return this.population;
    }

    @Override
    public Population getPopulationByTopiaId(String topiaId) {
        return (Population)TopiaEntityHelper.getEntityByTopiaId(this.population, (String)topiaId);
    }

    @Override
    public int sizePopulation() {
        if (this.population == null) {
            return 0;
        }
        return this.population.size();
    }

    @Override
    public boolean isPopulationEmpty() {
        int size = this.sizePopulation();
        return size == 0;
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList<Population> tmp = new ArrayList<Population>();
        TopiaDAO dao = ((TopiaContextImplementor)this.getTopiaContext()).getDAO(TargetSpecies.class);
        List findAllByProperties = dao.findAllByProperties("species", (Object)this, new Object[0]);
        if (findAllByProperties != null) {
            tmp.addAll(findAllByProperties);
        }
        if (this.getPopulation() != null) {
            tmp.addAll(this.getPopulation());
        }
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity topiaEntity : tmp) {
            if (topiaEntity == null) continue;
            result.add(topiaEntity);
            result.addAll(topiaEntity.getComposite());
        }
        return result;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("name", (Object)this.name).append("scientificName", (Object)this.scientificName).append("codeRubbin", (Object)this.codeRubbin).append("codeCEE", this.codeCEE).append("ageGroupType", this.ageGroupType).append("comment", (Object)this.comment).toString();
        return result;
    }
}

