/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.actions;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.DataStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.FormuleStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.ScriptStorage;
import fr.ifremer.isisfish.datastore.SimulationPlanStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.datastore.SimulatorStorage;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.i18n.I18n;

public class ExportAction {
    private static Log log = LogFactory.getLog(ExportAction.class);
    protected IsisConfig config = null;

    public ExportAction(IsisConfig config) {
        this.config = config;
    }

    protected void applyFilter(String filter, List<String> names) {
        if (filter != null && !"*".equals(filter)) {
            Pattern p = Pattern.compile(filter);
            Iterator<String> i = names.iterator();
            while (i.hasNext()) {
                String name = i.next();
                if (p.matcher(name).matches()) continue;
                i.remove();
            }
        }
    }

    protected void display(String filter, List<String> names) {
        StringBuilder sb = new StringBuilder();
        sb.append(" found ").append(names.size());
        sb.append(" with filter ").append(filter);
        sb.append(" in IsisFish");
        for (String name : names) {
            sb.append("\n").append(name);
        }
        System.out.println(sb.toString());
    }

    @ApplicationConfig.Action.Step(value=1)
    public void listSimulationPlan(String filter) throws Exception {
        List<String> names = SimulationPlanStorage.getSimulationPlanNames();
        this.applyFilter(filter, names);
        this.display(filter, names);
    }

    @ApplicationConfig.Action.Step(value=1)
    public void listExport(String filter) throws Exception {
        List<String> names = ExportStorage.getExportNames();
        this.applyFilter(filter, names);
        this.display(filter, names);
    }

    @ApplicationConfig.Action.Step(value=1)
    public void listRule(String filter) throws Exception {
        List<String> names = RuleStorage.getRuleNames();
        this.applyFilter(filter, names);
        this.display(filter, names);
    }

    @ApplicationConfig.Action.Step(value=1)
    public void listScript(String filter) throws Exception {
        List<String> names = ScriptStorage.getScriptNames();
        this.applyFilter(filter, names);
        this.display(filter, names);
    }

    @ApplicationConfig.Action.Step(value=1)
    public void listRegion(String filter) throws Exception {
        List<String> names = RegionStorage.getRegionNames();
        this.applyFilter(filter, names);
        this.display(filter, names);
    }

    @ApplicationConfig.Action.Step(value=1)
    public void listSimulation(String filter) throws Exception {
        List<String> names = SimulationStorage.getSimulationNames();
        this.applyFilter(filter, names);
        this.display(filter, names);
    }

    @ApplicationConfig.Action.Step(value=1)
    public void listSimulator(String filter) throws Exception {
        List<String> names = SimulatorStorage.getSimulatorNames();
        this.applyFilter(filter, names);
        this.display(filter, names);
    }

    @ApplicationConfig.Action.Step(value=1)
    public void listFormula(String filter) throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : FormuleStorage.getCategories()) {
            names.addAll(FormuleStorage.getFormuleNames(name));
        }
        this.applyFilter(filter, names);
        this.display(filter, names);
    }

    @ApplicationConfig.Action.Step(value=1)
    public void exportRegion(File file, String name, boolean force) throws Exception {
        log.info((Object)("file:" + file + ", name:" + name));
        if (!force && file.exists()) {
            throw new IllegalArgumentException(I18n.t((String)"destination already exists %s use 'force' argument to force overwrite", (Object[])new Object[]{file}));
        }
        if (!RegionStorage.exists(name)) {
            throw new IllegalArgumentException(I18n.t((String)"could not found region %s", (Object[])new Object[]{name}));
        }
        RegionStorage data = RegionStorage.getRegion(name);
        if (data != null) {
            data.createZip(file);
        }
    }

    @ApplicationConfig.Action.Step(value=1)
    public void exportSimulation(File file, String name, boolean force) throws Exception {
        log.info((Object)("exportSimulation in file " + file + " ( " + name + ", force = " + force + ")"));
        if (!force && file.exists()) {
            throw new IllegalArgumentException(I18n.t((String)"destination already exists %s use 'force' argument to force overwrite", (Object[])new Object[]{file}));
        }
        if (!SimulationStorage.exists(name)) {
            throw new IllegalArgumentException(I18n.t((String)"could not found simulation %s", (Object[])new Object[]{name}));
        }
        SimulationStorage data = SimulationStorage.getSimulation(name);
        if (data != null) {
            ((DataStorage)data).createZip(file);
        }
    }

    @ApplicationConfig.Action.Step(value=1)
    public void exportSimulationPlan(File file, String name, boolean force) throws Exception {
        if (!force && file.exists()) {
            throw new IllegalArgumentException(I18n.t((String)"destination already exists %s use 'force' argument to force overwrite", (Object[])new Object[]{file}));
        }
        SimulationPlanStorage storage = SimulationPlanStorage.getSimulationPlan(name, new CodeSourceStorage.Location[0]);
        if (!storage.exists()) {
            throw new IllegalArgumentException(I18n.t((String)"could not found %s", (Object[])new Object[]{name}));
        }
        String content = storage.getContent();
        FileUtils.writeStringToFile((File)file, (String)content);
    }

    @ApplicationConfig.Action.Step(value=1)
    public void exportRule(File file, String name, boolean force) throws Exception {
        if (!force && file.exists()) {
            throw new IllegalArgumentException(I18n.t((String)"destination already exists %s use 'force' argument to force overwrite", (Object[])new Object[]{file}));
        }
        RuleStorage storage = RuleStorage.getRule(name, new CodeSourceStorage.Location[0]);
        if (!storage.exists()) {
            throw new IllegalArgumentException(I18n.t((String)"could not found %s", (Object[])new Object[]{name}));
        }
        String content = storage.getContent();
        FileUtils.writeStringToFile((File)file, (String)content);
    }

    @ApplicationConfig.Action.Step(value=1)
    public void exportScript(File file, String name, boolean force) throws Exception {
        if (!force && file.exists()) {
            throw new IllegalArgumentException(I18n.t((String)"destination already exists %s use 'force' argument to force overwrite", (Object[])new Object[]{file}));
        }
        ScriptStorage storage = ScriptStorage.getScript(name, new CodeSourceStorage.Location[0]);
        if (!storage.exists()) {
            throw new IllegalArgumentException(I18n.t((String)"could not found %s", (Object[])new Object[]{name}));
        }
        String content = storage.getContent();
        FileUtils.writeStringToFile((File)file, (String)content);
    }

    @ApplicationConfig.Action.Step(value=1)
    public void exportExport(File file, String name, boolean force) throws Exception {
        if (!force && file.exists()) {
            throw new IllegalArgumentException(I18n.t((String)"destination already exists %s use 'force' argument to force overwrite", (Object[])new Object[]{file}));
        }
        ExportStorage storage = ExportStorage.getExport(name, new CodeSourceStorage.Location[0]);
        if (!storage.exists()) {
            throw new IllegalArgumentException(I18n.t((String)"could not found %s", (Object[])new Object[]{name}));
        }
        String content = storage.getContent();
        FileUtils.writeStringToFile((File)file, (String)content);
    }

    @ApplicationConfig.Action.Step(value=1)
    public void exportSimulator(File file, String name, boolean force) throws Exception {
        if (!force && file.exists()) {
            throw new IllegalArgumentException(I18n.t((String)"destination already exists %s use 'force' argument to force overwrite", (Object[])new Object[]{file}));
        }
        SimulatorStorage storage = SimulatorStorage.getSimulator(name, new CodeSourceStorage.Location[0]);
        if (!storage.exists()) {
            throw new IllegalArgumentException(I18n.t((String)"could not found %s", (Object[])new Object[]{name}));
        }
        String content = storage.getContent();
        FileUtils.writeStringToFile((File)file, (String)content);
    }

    @ApplicationConfig.Action.Step(value=1)
    public void exportFormula(File file, String category, String name, boolean force) throws Exception {
        if (!force && file.exists()) {
            throw new IllegalArgumentException(I18n.t((String)"destination already exists %s use 'force' argument to force overwrite", (Object[])new Object[]{file}));
        }
        FormuleStorage storage = FormuleStorage.getFormule(category, name);
        if (!storage.exists()) {
            throw new IllegalArgumentException(I18n.t((String)"could not found %s", (Object[])new Object[]{name}));
        }
        String content = storage.getContent();
        FileUtils.writeStringToFile((File)file, (String)content);
    }
}

