package fr.ifremer.isisfish.ui.input.equation;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Formule;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.widget.text.SyntaxEditor;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import static org.nuiton.i18n.I18n.t;

public class InputOneEquationUI extends InputContentUI<org.nuiton.topia.persistence.TopiaEntityContextable> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_AUTO_SAVE_MODIFICATION = "autoSaveModification";
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_BEAN_PROPERTY = "beanProperty";
    public static final String PROPERTY_CLAZZ = "clazz";
    public static final String PROPERTY_FORMULE = "formule";
    public static final String PROPERTY_FORMULE_CATEGORY = "formuleCategory";
    public static final String PROPERTY_SELECTED_EQUATION = "selectedEquation";
    public static final String PROPERTY_TEXT = "text";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_FORMULE_COMBO_BOX_ENABLED = "formuleComboBox.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTY8TRxDtdfB+8bFLNqCNINImMRKHqE2CIiEtLGSXtdYr86EYJISlKG1P2W4y7h66a9gxhyg/IT8huecSKTdOiANnDlxQ/kIU5ZBrlOoe22Mvs4vF+uCxquu9elVd8/zbX6xoDfv0kUgSbmKFsgd895sHD+40H0ELb4JtGRmhNiz9zBRYocGOB6O4RfZ5o+bg5QG8vKV7kVagxtDrNbZosR+C7QIgsk8mES1ry/XR8XoSxWbIOhKVx/rLP38Xfg5++rXAWBKRutPUytq7UFknx2qsIANkH1KlJ6IcCtUhGUaqDuk96WJbobD2tujBY/Yjm6ux2UgYIkP22fQtew6PTyJky6WqimLc0gop/X71ErIrbcNl20AP6GmlbUvb5bHk0iVyeBwLlFpxj7ujYHsQuF+NIs87i+wYQkKqlp1m7vrgaR9jGU0QCtllbTpcxRKJEHUkBY/AUE0S0wJ+z0W2qSXse4EJimYIGckJR3LXaMJg38VOZWfFViiePkW2lGnwnWcZc21tenEIyEp5HYOrK8HySpqWAZcGwC2B0NFmf+VlCyHtKgTDySC7cGiBYV5G8ZGIUdfFE7ilA9mWrQHN6ayXTa1Dan6sm65QQUiDYNfe7/52Uvz4FemgT9voiibc7tH98d27QkE4VrV0z10Jbc3qxJ6n2f7MZV4YAeZLuzXRhPDSfmIfdUkX356z7jX1pk6QnZmADOOTqIXS7maMtFBUYmUiPw1PZs9CQMtHUysfMLU9GXQAuVs+Xu8rFMm2RxxQ9EsXuDw4NOzcxFTIV3jmK9mLP9NgRUONknmtNt62om/pKDWh1X0m5Aj96X9nV14/+/OPytB5Fqn2mdzUMeMkR4jSl0e60kup7cQow/ItEa032EK6yd5Vz+cIqw+OSRzVS7fTwfmOsF2iKM69ef7i7PevPmCFClsMtQgqwuVX2QJ2DU1Bh0ESXb/hFZ3Ym6fvZaeN9gqU2x0yw1NXA4FirSlVQJe4kdAUzudMYSSlufDy35X67zeGk5ghZR8fmJ5No/iQzUoVSgXehQcGm+u6xyMLcaAzI82z1hn3/CIavCob/nszr1Xvle50O4ndo+JFu187U3K48M1DGMpTqJin/5EADJgj8bxLyVdTMdTIG66md7EmkP44mjHCxvsyIjsp7A/V9m2NzlH9zX6XT/b1kRs8OsOV6UZ0SBeO4X/BRwp1SAkAAA==";
    private static final Log log = LogFactory.getLog(InputOneEquationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean autoSaveModification;
    protected TopiaEntityContextable bean;
    protected String beanProperty;
    protected Class clazz;
    protected SyntaxEditor editor;
    protected Formule formule;
    protected String formuleCategory;
    protected JComboBox<Formule> formuleComboBox;
    protected InputOneEquationHandler handler;
    protected Equation selectedEquation;
    protected String text;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private InputOneEquationUI $InputContentUI0 = this;
    private JButton $JButton0;
    private JButton $JButton1;
    private JLabel $JLabel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public InputOneEquationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public InputOneEquationUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public InputOneEquationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public InputOneEquationUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public InputOneEquationUI() {
        $initialize();
    }

    public InputOneEquationUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public InputOneEquationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public InputOneEquationUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveModel();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openEditor();
    }

    public void doActionPerformed__on__formuleComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.formuleChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAutoSaveModification() {
        return autoSaveModification;
    }

    public TopiaEntityContextable getBean() {
        return bean;
    }

    public String getBeanProperty() {
        return beanProperty;
    }

    public Class getClazz() {
        return clazz;
    }

    public SyntaxEditor getEditor() {
        return editor;
    }

    public Formule getFormule() {
        return formule;
    }

    public String getFormuleCategory() {
        return formuleCategory;
    }

    public JComboBox<Formule> getFormuleComboBox() {
        return formuleComboBox;
    }

    public InputOneEquationHandler getHandler() {
        return handler;
    }

    public Equation getSelectedEquation() {
        return selectedEquation;
    }

    public String getText() {
        return text;
    }

    public Boolean isAutoSaveModification() {
        return autoSaveModification !=null && autoSaveModification;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAutoSaveModification(Boolean autoSaveModification) {
        Boolean oldValue = this.autoSaveModification;
        this.autoSaveModification = autoSaveModification;
        firePropertyChange(PROPERTY_AUTO_SAVE_MODIFICATION, oldValue, autoSaveModification);
    }

    public void setBean(TopiaEntityContextable bean) {
        TopiaEntityContextable oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setBeanProperty(String beanProperty) {
        String oldValue = this.beanProperty;
        this.beanProperty = beanProperty;
        firePropertyChange(PROPERTY_BEAN_PROPERTY, oldValue, beanProperty);
    }

    public void setClazz(Class clazz) {
        Class oldValue = this.clazz;
        this.clazz = clazz;
        firePropertyChange(PROPERTY_CLAZZ, oldValue, clazz);
    }

    public void setFormule(Formule formule) {
        Formule oldValue = this.formule;
        this.formule = formule;
        firePropertyChange(PROPERTY_FORMULE, oldValue, formule);
    }

    public void setFormuleCategory(String formuleCategory) {
        String oldValue = this.formuleCategory;
        this.formuleCategory = formuleCategory;
        firePropertyChange(PROPERTY_FORMULE_CATEGORY, oldValue, formuleCategory);
    }

    public void setSelectedEquation(Equation selectedEquation) {
        Equation oldValue = this.selectedEquation;
        this.selectedEquation = selectedEquation;
        firePropertyChange(PROPERTY_SELECTED_EQUATION, oldValue, selectedEquation);
    }

    public void setText(String text) {
        String oldValue = this.text;
        this.text = text;
        firePropertyChange(PROPERTY_TEXT, oldValue, text);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void createAutoSaveModification() {
        $objectMap.put("autoSaveModification", autoSaveModification = true);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createBeanProperty() {
        $objectMap.put("beanProperty", beanProperty = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createClazz() {
        $objectMap.put("clazz", clazz = null);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new SyntaxEditor());
        
        editor.setName("editor");
        editor.setAskIfNotSaved(false);
    }

    protected void createFormule() {
        $objectMap.put("formule", formule = null);
    }

    protected void createFormuleCategory() {
        $objectMap.put("formuleCategory", formuleCategory = null);
    }

    protected void createFormuleComboBox() {
        $objectMap.put("formuleComboBox", formuleComboBox = new JComboBox<Formule>());
        
        formuleComboBox.setName("formuleComboBox");
        formuleComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__formuleComboBox"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new InputOneEquationHandler(this));
    }

    protected void createSelectedEquation() {
        $objectMap.put("selectedEquation", selectedEquation = null);
    }

    protected void createText() {
        $objectMap.put("text", text = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(formuleComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(editor, new GridBagConstraints(1, 1, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        formuleComboBox.setRenderer(new FormuleComboRenderer());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createText();
        createBean();
        createBeanProperty();
        createClazz();
        createFormule();
        createFormuleCategory();
        createSelectedEquation();
        createAutoSaveModification();
        createHandler();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        createFormuleComboBox();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("isisfish.common.saveModel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createEditor();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("isisfish.common.openEditor"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"text") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(t(getText()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FORMULE_COMBO_BOX_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                formuleComboBox.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isActive() && formuleCategory != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                editor.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isActive() && clazz != null && formuleCategory != null);
            }
        });
    }

}