package fr.ifremer.isisfish.ui;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.datastore.RegionStorage;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public abstract class SimulationUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_REGION_STORAGE = "regionStorage";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRAdm9ixHRLAISYBIwUIEghxRoLOEQSCothyAMUgRbhhz7e2N7qPZXcvOTeIn8BPgJ4GiY4KUVBT0CD+AkIUtIjZ88fZ+JCRcLFnz7x5+2bujV9/g5QUcG6fBIEhfFcxhxrV23t798192lR3qWwKxpUnoPdJJCHZgDlrGJcKLjRqurzULy9teg73XOqOVJdrkJOqa1PZoVQpODte0ZSyVB+mywH3xYB1KCqO9eWP78kX1vNXSYCAo7oMtrI6rSrqZKYGSWYpyONNB6RkE7eNMgRz26h3Xsc2bSLlPeLQp/AMZmuQ5kQgmYLz/95yyBHWB1xBZq36gLjUvoZzawmDtQR1KD4lky0mO4bPjDpzfJso5rmPKpyHpWkFsx3iWjYVCi5NrdvuQaPieUHbGK+jLtKmCq7EUVhEEYkIauyOoiOW3Fp1h7r+HSJQ/Uk9n8CQhzguYxDXwGwkuYdH8IkJsIbkh8i0w+rkAIUtTQArijoatTQEZxxWwXELpX+fHs8tmJ7VfUhMk1p6zApOjRFGmb5SAWfG/IJONCInRlZJNCAlfAwrWG5MmncXUz3bLv9hW00YZn8VFj+/+/p2a+DVGbx7KRY6smroIS48jm+d6auP9YzqK2aXdggvNyArqY17Gu5hMUZYvZ9GcXhf+BoMXW5sE9lBitTsl/cfCk8+HYHkFuRsj1hbROMrkFUdgVPwbCvgtzZCRUcPM3ge19rwldmk6/m4Cgvr2jirJnMtnPHNAIdQjBnCUImZ/fhzsf5mYzCIBApb+Ss8GkbqMaSZazOXhmvb38jYNZ3jkvqWF21e3C4m9DPH+/a+GJ6X4zqdUTTAPvPrvdtXicL/CNNXFHvVRVfDJvS3UshZmMqpw9f1cSOeYeW/GYrI8BujK5ls3AUAAA==";
    private static final Log log = LogFactory.getLog(SimulationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTabbedPane bodyTabbedPane;
    protected SimulationHandler handler;
    protected JMenuItem miImport;
    protected JMenuItem miSave;
    protected RegionStorage regionStorage;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JMenu $JMenu0;
    private JMenuBar $JMenuBar0;
    private SimulationUI $JPanel0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }
    
        /**
         * Refresh all simulation launch UI.
         */
        protected abstract void regionStorageChanged();
    
        /**
         * Refresh all simulation launch UI.
         */
        protected abstract void refresh();
    
        /**
         * Set selected tab to parameters tab.
         */
        public abstract void selectParametersTab();
    
        /**
         * Change prescript tab enabled property.
         */
        public abstract void setEnabledPrescriptTab(boolean selected);
        
        /**
         * Change simulation plan tab enabled property.
         */
        public abstract void setEnabledSimulationPlanTab(boolean selected);
    
        /**
         * Change optimization tab enabled property.
         */
        public abstract void setEnabledOptimizationTab(boolean selected);
    
        /**
         * Rafraichit l'arbre des facteurs.
         */
        public void refreshFactorTree() {
        
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SimulationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimulationUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SimulationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SimulationUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SimulationUI() {
        $initialize();
    }

    public SimulationUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SimulationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SimulationUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__miImport(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importSimulation();
    }

    public void doActionPerformed__on__miSave(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveSimulation();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTabbedPane getBodyTabbedPane() {
        return bodyTabbedPane;
    }

    public SimulationHandler getHandler() {
        return handler;
    }

    public JMenuItem getMiImport() {
        return miImport;
    }

    public JMenuItem getMiSave() {
        return miSave;
    }

    public RegionStorage getRegionStorage() {
        return regionStorage;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setRegionStorage(RegionStorage regionStorage) {
        RegionStorage oldValue = this.regionStorage;
        this.regionStorage = regionStorage;
        firePropertyChange(PROPERTY_REGION_STORAGE, oldValue, regionStorage);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenu get$JMenu0() {
        return $JMenu0;
    }

    protected JMenuBar get$JMenuBar0() {
        return $JMenuBar0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBodyTabbedPane() {
        $objectMap.put("bodyTabbedPane", bodyTabbedPane = new JTabbedPane());
        
        bodyTabbedPane.setName("bodyTabbedPane");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new SimulationHandler(this));
    }

    protected void createMiImport() {
        $objectMap.put("miImport", miImport = new JMenuItem());
        
        miImport.setName("miImport");
        miImport.setText(t("isisfish.simulation.menu.import"));
        miImport.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miImport"));
    }

    protected void createMiSave() {
        $objectMap.put("miSave", miSave = new JMenuItem());
        
        miSave.setName("miSave");
        miSave.setText(t("isisfish.simulation.menu.save"));
        miSave.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__miSave"));
    }

    protected void createRegionStorage() {
        $objectMap.put("regionStorage", regionStorage = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($JMenuBar0, BorderLayout.NORTH);
        add(SwingUtil.boxComponentWithJxLayer(bodyTabbedPane), BorderLayout.CENTER);
        // inline complete setup of $JMenuBar0
        $JMenuBar0.add($JMenu0);
        // inline complete setup of $JMenu0
        $JMenu0.add(miSave);
        $JMenu0.add(miImport);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createRegionStorage();
        // inline creation of $JMenuBar0
        $objectMap.put("$JMenuBar0", $JMenuBar0 = new JMenuBar());
        
        $JMenuBar0.setName("$JMenuBar0");
        // inline creation of $JMenu0
        $objectMap.put("$JMenu0", $JMenu0 = new JMenu());
        
        $JMenu0.setName("$JMenu0");
        $JMenu0.setText(t("isisfish.simulation.menu.simulation"));
        createMiSave();
        createMiImport();
        createBodyTabbedPane();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

}