/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.sensitivity;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import static org.nuiton.i18n.I18n._;

public class MatrixContinuousPanelUI extends ContinuousPanelContainerUI {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_PERCENTAGE_TYPE_FACTOR = "percentageTypeFactor";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JRADIO_BUTTON0_SELECTED = "$JRadioButton0.selected";
    private static final String BINDING_$JRADIO_BUTTON1_SELECTED = "$JRadioButton1.selected";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUO28TQRDemLzfL5yXIwIxBQ+dA6IiEYQkWNg4gPJAERYS67u1vdH59tjdS84N4ifwE6CnQaKjQhTUFDSIv4AQBS1ids+xfcklWMTF2p6Z75tvZnfm7Q/UITg6v4t93+CeI2mFGNk7OzsPC7vElGtEmJy6knEUfNpiKJZHfVbdLiSaz+cUPFWDp1ZZxWUOcZrQiznUK2TVJqJMiJRoNowwhUht1t2LvuvxA9a6qCjW179+xl5ZL9/EEPJdUDcKpcz9C9WopD2HYtSSaBQy7eGUjZ0SyODUKYHeAWVbtbEQD3CFPEcvUFcOdbqYA5lEF1ovWXNovO9KlEiuMsA4HvPEI+wQW/3F1CF8O7Mg0c0iN2iRkwqBb0FFkYqy4VFDEEdQSfeorBrrGDT6h2i2M66rs3RKNO4SboIYXCJbVZeksQl6JBpRFRmqSmOFMZtgpwHpMoFOVzaqonxD7EMbjKzmbgpLbuGCTUDoZKjNQbT2qcihOmAwmd3AFmUrnpTMCXBN9E0+BRg9BndNWSfCEf1laql8WqGyjYT9NakaOq6O6bqrO5nN4QKxFw5Xq60qKFGPHeOkSODOTfIY216QTaKrjJcMx6OgzahgWVYH3IlRgqsKrkcH3rUggocJD5JrYXNh37DJSLFITQo3kabEhrcZDwncIn7gCONqtV6PqHUgmQVfgVhKEBQ8Eearu1T4pQaqQp1Gvco4r44rTQHYPzGgR0nKOEUGOaej34ryukcBujE3wMHRTAgIW8JobInGGLflUQf3wAyvK390sWyAK1gpk4dWiiLU3j/xsa8fvr9PH+yRHsh9NjK0aQ3CfLucwahJqlIPBUvEk9ROrWN3MQ8sxCZmsCMTEcI2a24QB/mC6VRw4x4WZaDo6Pr28VP82ZczKJZGvTbDVjDJGdQjyxy6wGzLd28va0X9+91wDitt8MaCzATez+CShSWeK1DHgrbf8qENiYg21LUUej7/Htt8t3zQijaQNnVseKMdHU9QJ3VsWGR6qdb2ZeQS7XMF8SzW2ItRm7JNfcfd2vtY0udyVK3tEmYCBnkpyD6HJYxfwZMEalWgNV2E+pVukVOZV9SxGs0w1RJDVh33/5dBok4bV5knT9Ax0wpLgXGL8BNYZk9dzblTM1xsieHpCVVcBoa/r/8FHswIAAA=";
    private static final Log log = LogFactory.getLog(MatrixContinuousPanelUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextField coefficientField;
    protected JPanel hidablePanel;
    protected MatrixPanelEditor maxValuePanel;
    protected MatrixPanelEditor minValuePanel;
    protected Boolean percentageTypeFactor;
    protected MatrixPanelEditor referenceValuePanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MatrixContinuousPanelUI $ContinuousPanelContainerUI0 = this;
    private Table $Table0;
    private JRadioButton $JRadioButton0;
    private JRadioButton $JRadioButton1;
    private Table $Table1;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private Table $Table2;
    private JTabbedPane $JTabbedPane0;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(MatrixND min, MatrixND max, MatrixND referenceValue, String coefficient) {
        minValuePanel.setMatrix(min);
        maxValuePanel.setMatrix(max);
        referenceValuePanel.setMatrix(referenceValue);
        coefficientField.setText(coefficient);
    }
    
    public void initExisting(MatrixND min, MatrixND max, MatrixND referenceValue, String coefficient) {
        init(min, max, referenceValue, coefficient);
        setPercentageTypeFactor(StringUtils.isNotBlank(coefficient));
    }
    
    @Override
    public boolean isFactorValid() {
        boolean valid = false;
        
        try {
            if (continueSelected) {
                if (percentageTypeFactor) {
                    Double coefficient = Double.parseDouble(coefficientField.getText().trim());
                    valid = coefficient != null;
                }
                else {
                    valid = true;
                }
            }
            else {
                valid = true;
            }
        }
        catch (NumberFormatException eee) {
            if (log.isWarnEnabled()) {
                log.warn("Double parse error", eee);
            }
        }
        
        return valid;
    }
    
    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_PERCENTAGE_TYPE_FACTOR, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ((Boolean)evt.getNewValue()) {
                    ((CardLayout) hidablePanel.getLayout()).show(hidablePanel, "percentageType");
                } else {
                    ((CardLayout) hidablePanel.getLayout()).show(hidablePanel, "minMaxType");
                }
            }
        });
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MatrixContinuousPanelUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MatrixContinuousPanelUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public MatrixContinuousPanelUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public MatrixContinuousPanelUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MatrixContinuousPanelUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public MatrixContinuousPanelUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MatrixContinuousPanelUI() {
        $initialize();
    }

    public MatrixContinuousPanelUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JRadioButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setPercentageTypeFactor(true);
    }

    public void doActionPerformed__on__$JRadioButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setPercentageTypeFactor(false);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextField getCoefficientField() {
        return coefficientField;
    }

    public JPanel getHidablePanel() {
        return hidablePanel;
    }

    public MatrixPanelEditor getMaxValuePanel() {
        return maxValuePanel;
    }

    public MatrixPanelEditor getMinValuePanel() {
        return minValuePanel;
    }

    public Boolean getPercentageTypeFactor() {
        return percentageTypeFactor;
    }

    public MatrixPanelEditor getReferenceValuePanel() {
        return referenceValuePanel;
    }

    public Boolean isPercentageTypeFactor() {
        return percentageTypeFactor !=null && percentageTypeFactor;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setPercentageTypeFactor(Boolean percentageTypeFactor) {
        Boolean oldValue = this.percentageTypeFactor;
        this.percentageTypeFactor = percentageTypeFactor;
        firePropertyChange(PROPERTY_PERCENTAGE_TYPE_FACTOR, oldValue, percentageTypeFactor);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JRadioButton get$JRadioButton0() {
        return $JRadioButton0;
    }

    protected JRadioButton get$JRadioButton1() {
        return $JRadioButton1;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected JTabbedPane get$JTabbedPane0() {
        return $JTabbedPane0;
    }

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToContent() {
        if (!allComponentsCreated) {
            return;
        }
        content.add($Table0, BorderLayout.CENTER);
    }

    protected void addChildrenToHidablePanel() {
        if (!allComponentsCreated) {
            return;
        }
        hidablePanel.add($Table1, "percentageType");
        hidablePanel.add($Table2, "minMaxType");
    }

    protected void createCoefficientField() {
        $objectMap.put("coefficientField", coefficientField = new JTextField());
        
        coefficientField.setName("coefficientField");
        coefficientField.setColumns(15);
    }

    @Override
    protected void createContent() {
        super.createContent();
        content.setName("content");
    }

    protected void createHidablePanel() {
        $objectMap.put("hidablePanel", hidablePanel = new JPanel());
        
        hidablePanel.setName("hidablePanel");
        hidablePanel.setLayout(new CardLayout());
    }

    protected void createMaxValuePanel() {
        $objectMap.put("maxValuePanel", maxValuePanel = new MatrixPanelEditor());
        
        maxValuePanel.setName("maxValuePanel");
    }

    protected void createMinValuePanel() {
        $objectMap.put("minValuePanel", minValuePanel = new MatrixPanelEditor());
        
        minValuePanel.setName("minValuePanel");
    }

    protected void createPercentageTypeFactor() {
        $objectMap.put("percentageTypeFactor", percentageTypeFactor = true);
    }

    protected void createReferenceValuePanel() {
        $objectMap.put("referenceValuePanel", referenceValuePanel = new MatrixPanelEditor());
        
        referenceValuePanel.setName("referenceValuePanel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToContent();
        // inline complete setup of $Table0
        $Table0.add($JRadioButton0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JRadioButton1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(hidablePanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToHidablePanel();
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(referenceValuePanel, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(coefficientField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JTabbedPane0, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JTabbedPane0
        $JTabbedPane0.add(minValuePanel);
        $JTabbedPane0.add(maxValuePanel);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 0));
        $JTabbedPane0.setTitleAt(0, _("isisfish.sensitivity.firstValue"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener($JTabbedPane0, 1));
        $JTabbedPane0.setTitleAt(1, _("isisfish.sensitivity.lastValue"));
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        $Table1.setBorder(BorderFactory.createTitledBorder(""));
        $Table2.setBorder(BorderFactory.createTitledBorder(""));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$ContinuousPanelContainerUI0", $ContinuousPanelContainerUI0);
        createPercentageTypeFactor();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JRadioButton0
        $objectMap.put("$JRadioButton0", $JRadioButton0 = new JRadioButton());
        
        $JRadioButton0.setName("$JRadioButton0");
        $JRadioButton0.setText(_("isisfish.sensitivity.continuouspercentagetype"));
        $JRadioButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JRadioButton0"));
        // inline creation of $JRadioButton1
        $objectMap.put("$JRadioButton1", $JRadioButton1 = new JRadioButton());
        
        $JRadioButton1.setName("$JRadioButton1");
        $JRadioButton1.setText(_("isisfish.sensitivity.continuousminmaxtype"));
        $JRadioButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JRadioButton1"));
        createHidablePanel();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("isisfish.sensitivity.referencevalue"));
        createReferenceValuePanel();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.sensitivity.coefficient"));
        createCoefficientField();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JTabbedPane0
        $objectMap.put("$JTabbedPane0", $JTabbedPane0 = new JTabbedPane());
        
        $JTabbedPane0.setName("$JTabbedPane0");
        createMinValuePanel();
        createMaxValuePanel();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(_("isisfish.sensitivity.firstValue"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(_("isisfish.sensitivity.lastValue"));
        // inline creation of $ContinuousPanelContainerUI0
        setName("$ContinuousPanelContainerUI0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JRADIO_BUTTON0_SELECTED, true ,"percentageTypeFactor") {
        
            @Override
            public void processDataBinding() {
                $JRadioButton0.setSelected(isPercentageTypeFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JRADIO_BUTTON1_SELECTED, true ,"percentageTypeFactor") {
        
            @Override
            public void processDataBinding() {
                $JRadioButton1.setSelected(!isPercentageTypeFactor());
            }
        });
    }

}