/*
 * #%L
 * IsisFish
 * 
 * $Id: TopiaEntityListModel.java 3295 2011-04-29 09:19:09Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.0.0.0/src/main/java/fr/ifremer/isisfish/ui/input/model/TopiaEntityListModel.java $
 * %%
 * Copyright (C) 2009 - 2011 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.input.model;

import java.util.List;

import javax.swing.DefaultListModel;

import org.nuiton.topia.persistence.TopiaEntity;

/**
 * Model pour la liste des {@link TopiaEntity}.
 * 
 * Pas de selection par defaut.
 *
 * @author chatellier
 * @version $Revision: 3295 $
 * 
 * Last update : $Date: 2011-04-29 11:19:09 +0200 (ven., 29 avril 2011) $
 * By : $Author: chatellier $
 */
public class TopiaEntityListModel extends DefaultListModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6171850179969290032L;

    /** Zones list */
    protected List<? extends TopiaEntity> entities;

    /**
     * Constructor with entities list.
     * 
     * @param entities entities list
     */
    public TopiaEntityListModel(List<? extends TopiaEntity> entities) {
        this.entities = entities;
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return entities.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (entities != null) {
            size = entities.size();
        }
        return size;
    }

    /**
     * Return elements in model.
     * 
     * @return elements in model
     */
    public List<? extends TopiaEntity> getElements() {
        return entities;
    }
}
