/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.Strategy;
import java.awt.LayoutManager;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class StrategyUI extends InputContentUI<fr.ifremer.isisfish.entities.Strategy> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_STRATEGY_MONTH_INFO_UI_ACTIVE = "strategyMonthInfoUI.active";
    public static final String BINDING_STRATEGY_MONTH_INFO_UI_BEAN = "strategyMonthInfoUI.bean";
    public static final String BINDING_STRATEGY_TAB_UI_ACTIVE = "strategyTabUI.active";
    public static final String BINDING_STRATEGY_TAB_UI_BEAN = "strategyTabUI.bean";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1Tz08TQRR+rbRQEEGICAoJKsT4a4vxiFEMhlhS1FibEHtxyk7bIdvZceYtLBfjn+CfoHcvJt48GQ+ePXgx/gvGePBqfLNtt62s0j3sbN573zffe/u9N98hYzSc22Vh6OhAomhyZ/PO9vaD6i7fwbvc7Gih0NfQelJpSFdgzI3jBuFCpWjh+TY8v+43lS+57EGvFmHU4IHHTYNzRFjoR+wYky/F6dVQBbrDGotKYn3180f6pfvidRogVKRuhFpZPArV7WSoCGnhIkzRTXss7zFZJxlayDrpHbexdY8Zc581+TN4DsNFyCqmiQzh/OAtRxwRPlQIk0sFqQJc9yVSebmwgnCxph1R07zJ6TTC1IRpOIFwhC10SBBDXj8oF5SKaLIIQ1XOJMJyEpBYBQpuYmAvzHcPqF3bWeiYfWrU2XzIJPe6NWOmDXvMqgin+0opVOWuBdjiiRgz3oMpFxAuD9RQVGwZpmKi6Q7RFo2nUZA139KtDETXA+knzS3RTTZBoz7TZ45WW+2sOgy4bgMLlNBwtg9IfnW6fu0aKlWBjA4ojDBbOWzxR5RqmXv2L3Nbwij7e2b6y/tv7zY6jh6iu08llvYsJDlNaV9xbf87wkTLzgEKL7/F1GoFcoZ7tM3Rts4nCCu10ySO7jtp4Y6FO/eYaRBFZvjrh48zTz8fg/QGjHo+czeYrS9ADhuapuB7bqhur0WKju+P0HvSakPIUp3YoxmduOkyZItVIV0a+q2QhjCfMIRYSTX36dd06e1aZxApEjb3z/LuMDJPICukJySPlru9t4nLPKYMD1y/u59JG5uy54xqu2M5el9K6jTaSZu9Ggb2uBaJtl/5ATls+Mp/GOYGYrhxBMMfFDkH3/IFAAA=";
    private static final Log log = LogFactory.getLog(StrategyUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Strategy bean;
    protected StrategyMonthInfoUI strategyMonthInfoUI;
    protected JTabbedPane strategyTab;
    protected StrategyTabUI strategyTabUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private StrategyUI $InputContentUI0 = this;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        // install change listener
        // (depends on sensitivity can't be done on constructor)
        installChangeListener(strategyTab);
    }
    
    /*public void refresh() {
        getSaveVerifier().addCurrentPanel(strategyMonthInfoUI, strategyTabUI);
    }*/
    
    @Override
    public void setLayer(boolean active) {
        super.setLayer(active);
        strategyTabUI.setLayer(active);
        strategyMonthInfoUI.setLayer(active);
    }
    
    @Override
    public void resetChangeModel() {
        strategyTabUI.resetChangeModel();
        strategyMonthInfoUI.resetChangeModel();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public StrategyUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public StrategyUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public StrategyUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public StrategyUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public StrategyUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public StrategyUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public StrategyUI() {
        $initialize();
    }

    public StrategyUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Strategy getBean() {
        return bean;
    }

    public StrategyMonthInfoUI getStrategyMonthInfoUI() {
        return strategyMonthInfoUI;
    }

    public JTabbedPane getStrategyTab() {
        return strategyTab;
    }

    public StrategyTabUI getStrategyTabUI() {
        return strategyTabUI;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Strategy bean) {
        Strategy oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(strategyTab);
    }

    protected void addChildrenToStrategyTab() {
        if (!allComponentsCreated) {
            return;
        }
        strategyTab.add(strategyTabUI);
        strategyTab.add(strategyMonthInfoUI);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(strategyTab, 0));
        strategyTab.setTitleAt(0, _("isisfish.strategy.title"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(strategyTab, 1));
        strategyTab.setTitleAt(1, _("isisfish.strategyMonthInfo.title"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createStrategyMonthInfoUI() {
        $objectMap.put("strategyMonthInfoUI", strategyMonthInfoUI = new StrategyMonthInfoUI(this));
        
        strategyMonthInfoUI.setName("strategyMonthInfoUI");
    }

    protected void createStrategyTab() {
        $objectMap.put("strategyTab", strategyTab = new JTabbedPane());
        
        strategyTab.setName("strategyTab");
    }

    protected void createStrategyTabUI() {
        $objectMap.put("strategyTabUI", strategyTabUI = new StrategyTabUI(this));
        
        strategyTabUI.setName("strategyTabUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToStrategyTab();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createStrategyTab();
        createStrategyTabUI();
        createStrategyMonthInfoUI();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(_("isisfish.strategy.title"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(_("isisfish.strategyMonthInfo.title"));
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_TAB_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                strategyTabUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_TAB_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                strategyTabUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_MONTH_INFO_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                strategyMonthInfoUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_MONTH_INFO_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                strategyMonthInfoUI.setBean(getBean());
            }
        });
    }

}