/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper.IsisFishEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class PopulationGroupDAOAbstract<E extends PopulationGroup> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)PopulationGroup.class;
    }

    @Override
    public IsisFishEntityEnum getTopiaEntityEnum() {
        return IsisFishEntityEnum.PopulationGroup;
    }

    public E findById(int v) throws TopiaException {
        E result = findByProperty(PopulationGroup.PROPERTY_ID, v);
        return result;
    }

    public List<E> findAllById(int v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationGroup.PROPERTY_ID, v);
        return result;
    }

    public E findByAge(double v) throws TopiaException {
        E result = findByProperty(PopulationGroup.PROPERTY_AGE, v);
        return result;
    }

    public List<E> findAllByAge(double v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationGroup.PROPERTY_AGE, v);
        return result;
    }

    public E findByMinLength(double v) throws TopiaException {
        E result = findByProperty(PopulationGroup.PROPERTY_MIN_LENGTH, v);
        return result;
    }

    public List<E> findAllByMinLength(double v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationGroup.PROPERTY_MIN_LENGTH, v);
        return result;
    }

    public E findByMaxLength(double v) throws TopiaException {
        E result = findByProperty(PopulationGroup.PROPERTY_MAX_LENGTH, v);
        return result;
    }

    public List<E> findAllByMaxLength(double v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationGroup.PROPERTY_MAX_LENGTH, v);
        return result;
    }

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(PopulationGroup.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationGroup.PROPERTY_COMMENT, v);
        return result;
    }

    public E findByPopulation(Population v) throws TopiaException {
        E result = findByProperty(PopulationGroup.PROPERTY_POPULATION, v);
        return result;
    }

    public List<E> findAllByPopulation(Population v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationGroup.PROPERTY_POPULATION, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllContainsPopulationGroup(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Population.class, entity);
        if (!list.isEmpty()) {
            result.put(Population.class, list);
        }

        return result;
    }

} //PopulationGroupDAOAbstract<E extends PopulationGroup>
