/*
 * #%L
 * 
 * 
 * $Id: DatabaseMigrationClass.java 3445 2011-07-15 13:12:45Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.0.0.0/src/main/java/fr/ifremer/isisfish/datastore/migration/DatabaseMigrationClass.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.datastore.migration;

import static org.nuiton.i18n.I18n._;

import java.util.List;

import javax.swing.JOptionPane;

import org.nuiton.topia.migration.TopiaMigrationCallbackByClass;
import org.nuiton.util.Version;

import fr.ifremer.isisfish.IsisFishDAOHelper;

/**
 * Migration callback by class for all isis database migration.
 * 
 * @author chatellier
 * @version $Revision: 3445 $
 * 
 * Last update : $Date: 2011-07-15 15:12:45 +0200 (ven., 15 juil. 2011) $
 * By : $Author: chatellier $
 */
public class DatabaseMigrationClass extends TopiaMigrationCallbackByClass {

    protected static final Version VERSION_32 = new Version("3.2");
    protected static final Version VERSION_33 = new Version("3.3");
    protected static final Version VERSION_40 = new Version("4.0");

    public DatabaseMigrationClass() {
        super(new MigrationResolver());
    }

    protected static class MigrationResolver implements MigrationCallBackForVersionResolver {
        /*
         * @see org.nuiton.topia.migration.TopiaMigrationCallbackByClass.MigrationCallBackForVersionResolver#getCallBack(org.nuiton.util.Version)
         */
        @Override
        public Class<? extends MigrationCallBackForVersion> getCallBack(Version version) {
            Class<? extends MigrationCallBackForVersion> result = null;
            
            if (version.equals(VERSION_32)) {
                result = MigrationV0V32.class;
            }
            else if (version.equals(VERSION_33)) {
                result = MigrationV32V33.class;
            }
            else if (version.equals(VERSION_40)) {
                result = MigrationV33V40.class;
            }
            return result;
        }
        
    }

    /*
     * @see org.nuiton.topia.migration.AbstractTopiaMigrationCallback#getAvailableVersions()
     */
    @Override
    public Version[] getAvailableVersions() {
        Version[] result = new Version[] { VERSION_32, VERSION_33, VERSION_40 };
        return result;
    }

    /*
     * @see org.nuiton.topia.migration.AbstractTopiaMigrationCallback#getApplicationVersion()
     */
    @Override
    public Version getApplicationVersion() {
        Version appVersion = new Version(IsisFishDAOHelper.getModelVersion());
        return appVersion;
    }

    /*
     * @see org.nuiton.topia.migration.AbstractTopiaMigrationCallback#askUser(org.nuiton.util.Version, java.util.List)
     */
    @Override
    public boolean askUser(Version dbVersion, List<Version> versions) {
        boolean result = false;
        
        int answer = JOptionPane.showConfirmDialog(
                null, _("isisfish.misc.databasemigration.question", dbVersion, versions.get(versions.size() - 1)),
                _("isisfish.misc.databasemigration.title"),
                JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
        
        if (answer == JOptionPane.YES_OPTION) {
            result = true;
        }
        
        return result;
    }

}
