package fr.ifremer.echobase.ui.actions.removeData;

/*
 * #%L
 * EchoBase :: UI
 * $Id: ConfirmDelete.java 655 2012-09-12 16:12:57Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-1.2/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/removeData/ConfirmDelete.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.echobase.entities.ImportLog;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.DecoratorService;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.services.removedata.RemoveDataConfiguration;
import fr.ifremer.echobase.ui.actions.AbstractConfigureAction;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.IOException;

/**
 * Confirm to delete a import log.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.2
 */
public class ConfirmDelete extends AbstractConfigureAction<RemoveDataConfiguration> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(ConfirmDelete.class);

    protected ImportLog importLog;

    protected String voyage;

    protected String importType;

    public ConfirmDelete() {
        super(RemoveDataConfiguration.class);
    }

    public String getImportType() {
        return importType;
    }

    public ImportLog getImportLog() {
        return importLog;
    }

    public String getVoyage() {
        return voyage;
    }

    @Override
    protected RemoveDataConfiguration createModel() {
        return new RemoveDataConfiguration();
    }

    @Override
    protected void prepareExecuteAction(RemoveDataConfiguration model) throws IOException {

        // nothing special to do here
    }

    @Override
    protected void prepareInputAction(RemoveDataConfiguration model) {

        String importLogId = model.getImportLogId();

        Preconditions.checkArgument(StringUtils.isNotBlank(importLogId));

        if (log.isInfoEnabled()) {
            log.info("Load import log " + importLogId);
        }
        EchoBaseServiceSupport service =
                getService(EchoBaseServiceSupport.class);
        importLog = service.getEntityById(ImportLog.class, importLogId);

        importType = decorateEnums(importLog.getImportType()).entrySet().iterator().next().getValue();

        Voyage voyageEntity = service.getEntityById(Voyage.class, importLog.getVoyageId());
        this.voyage = getService(DecoratorService.class).decorate(getLocale(), voyageEntity, null);

    }

}