/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: Configure.java 420 2012-03-27 23:02:51Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.4/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/importDb/Configure.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.importDb;

import fr.ifremer.echobase.InputFile;
import fr.ifremer.echobase.services.ImportDbConfiguration;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

import java.io.File;

/**
 * Configure a db import.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class Configure extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(Configure.class);

    protected ImportDbConfiguration model;

    public ImportDbConfiguration getModel() {
        if (model == null) {
            model = new ImportDbConfiguration(getLocale());
        }
        return model;
    }

    public void setInputFileName(String fileName) {
        getModel().getInput().setFileName(fileName);
    }

    public void setInput(File file) {
        getModel().getInput().setFile(file);
    }

    public void setInputContentType(String contentType) {
        getModel().getInput().setContentType(contentType);
    }

    @Override
    public String input() throws Exception {

        // always remove configuration from session anytime coming here
        getEchoBaseSession().setImportDbConfiguration(null);
        return INPUT;
    }

    @Override
    public String execute() throws Exception {

        ImportDbConfiguration configuration = getModel();

        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(
                tempDirectory,
                "echobase-importDb-" + System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary(dataDirectory);
        configuration.setWorkingDirectory(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info("Temporary directory to use : " + dataDirectory);
        }

        InputFile input = configuration.getInput();
        copyFile(input, dataDirectory);

        // store configuration in session
        getEchoBaseSession().setImportDbConfiguration(configuration);
        return SUCCESS;
    }
}
