/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.validators;

import com.opensymphony.xwork2.validator.ValidationException;
import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.services.UserService;
import fr.ifremer.echobase.ui.validators.EchoBaseFieldValidatorSupport;

public class LoginValidator
extends EchoBaseFieldValidatorSupport {
    public void validateWhenNotSkip(Object object) throws ValidationException {
        UserService userService = (UserService)this.getFieldValue("userService", object);
        String login = (String)this.getFieldValue("email", object);
        String password = (String)this.getFieldValue("password", object);
        if (this.log.isInfoEnabled()) {
            this.log.info("try to log for user " + login, new String[0]);
        }
        try {
            EchoBaseUser user = userService.getUserByEmail(login);
            if (user == null) {
                this.addFieldError("email", this._("echobase.error.login.unknown", new Object[0]));
                return;
            }
            boolean passwordOk = userService.checkPassword(user, password);
            if (!passwordOk) {
                this.addFieldError("password", this._("echobase.error.bad.password", new Object[0]));
            }
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Could not validate login", (Throwable)e, new String[0]);
            }
            throw new ValidationException("Could not validate login : " + e.getMessage());
        }
    }

    public String getValidatorType() {
        return "login";
    }
}

