/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: SaveEntity.java 111 2011-11-23 18:01:02Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/trunk/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/dbeditor/SaveEntity.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.EchoBaseEntityEnum;
import fr.ifremer.echobase.entities.meta.TableMeta;
import fr.ifremer.echobase.services.DbEditorService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.ParameterAware;

import java.util.List;
import java.util.Map;

/**
 * Save the edition of a row of a table.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class SaveEntity extends EchoBaseActionSupport implements ParameterAware {

    private static final long serialVersionUID = 1L;

    /** Type of entity to save. */
    protected EchoBaseEntityEnum entityType;

    /** id of entity to save. */
    protected String id;

    /** Metas of the table */
    protected TableMeta tableMeta;

    protected Map<String, String[]> params;

    public void setEntityType(EchoBaseEntityEnum entityType) {
        this.entityType = entityType;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String execute() throws Exception {

        DbEditorService service = newService(DbEditorService.class);
        TableMeta tableMeta = service.getTableMetas(entityType);
        Map<String, String> properties = Maps.newHashMap();
        List<String> columnNames = tableMeta.getColumnNames();
        for (String columnName : columnNames) {
            if (params.containsKey(columnName)) {

                // there is a such property to edit
                String[] values = params.get(columnName);

                if (values.length > 0) {

                    // take only the first value
                    String propertyValue = values[0];
                    if (StringUtils.isNotEmpty(propertyValue)) {

                        // only keep properties with no empty value
                        properties.put(columnName, propertyValue);
                    }
                }
            }
        }

        service.saveEntity(tableMeta,
                           id,
                           properties,
                           getEchoBaseSession().getEchoBaseUser());


        return SUCCESS;
    }

    @Override
    public void setParameters(Map<String, String[]> parameters) {
        params = Maps.newHashMap();
        params.putAll(parameters);
    }

}

