/*
 * #%L
 * Coser :: Web
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric, Chemit Tony
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.common;

import fr.ifremer.coser.web.CoserWebConfig;

/**
 * Toutes les actions de type *Jsp* doivent étendre celle ci. Contient le code commun
 * récurent, et notamment les actions utilisé par le layout et devant
 * être presentes sur toutes les pages.
 *
 * @author chatellier
 * @version $Revision$
 *          <p/>
 *          Last update : $Date$
 *          By : $Author$
 */
public abstract class AbstractCoserJspAction extends AbstractCoserAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 311574866032741326L;

    /**
     * Recupere l'email dans la configuration.
     *
     * @return admin email
     */
    public String getAdminEmail() {
        CoserWebConfig config = getService().getConfig();
        String email = config.getAdminEmail();
        return email;
    }

    /**
     * Recupere l'email dans la configuration.
     *
     * @return admin email
     */
    public String getApplicationVersion() {
        CoserWebConfig config = getService().getConfig();
        String email = config.getApplicationVersion();
        return email;
    }

    /**
     * Get analytics id from configuration.
     *
     * @return analytics id
     */
    public String getAnalyticsId() {
        CoserWebConfig config = getService().getConfig();
        String id = config.getAnalyticsId();
        return id;
    }
}
