package fr.ifremer.coselmar.persistence.entity;

/*
 * #%L
 * Coselmar :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.coselmar.persistence.AbstractCoselmarTopiaDao;
import fr.ifremer.coselmar.persistence.CoselmarEntityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 11 16:13:01 UTC 2014")
public abstract class GeneratedCoselmarUserTopiaDao<E extends CoselmarUser> extends AbstractCoselmarTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) CoselmarUser.class;
    }

    @Override
    public CoselmarEntityEnum getTopiaEntityEnum() {
        return CoselmarEntityEnum.CoselmarUser;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            DocumentTopiaDao dao = topiaDaoSupplier
                    .getDao(Document.class, DocumentTopiaDao.class);
            List<Document> list = dao
                    .forProperties(Document.PROPERTY_OWNER, entity)
                    .findAll();
            for (Document item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getOwner())) {
                    item.setOwner(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMailIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CoselmarUser.PROPERTY_MAIL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMailEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CoselmarUser.PROPERTY_MAIL, v);
        return result;
    }

    @Deprecated
    public E findByMail(String v) {
        return forMailEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMail(String v) {
        return forMailEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CoselmarUser.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CoselmarUser.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFirstnameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CoselmarUser.PROPERTY_FIRSTNAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFirstnameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CoselmarUser.PROPERTY_FIRSTNAME, v);
        return result;
    }

    @Deprecated
    public E findByFirstname(String v) {
        return forFirstnameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFirstname(String v) {
        return forFirstnameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forQualificationIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CoselmarUser.PROPERTY_QUALIFICATION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forQualificationEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CoselmarUser.PROPERTY_QUALIFICATION, v);
        return result;
    }

    @Deprecated
    public E findByQualification(String v) {
        return forQualificationEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByQualification(String v) {
        return forQualificationEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPasswordIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CoselmarUser.PROPERTY_PASSWORD, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPasswordEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CoselmarUser.PROPERTY_PASSWORD, v);
        return result;
    }

    @Deprecated
    public E findByPassword(String v) {
        return forPasswordEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPassword(String v) {
        return forPasswordEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSaltIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CoselmarUser.PROPERTY_SALT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSaltEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CoselmarUser.PROPERTY_SALT, v);
        return result;
    }

    @Deprecated
    public E findBySalt(String v) {
        return forSaltEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySalt(String v) {
        return forSaltEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrganizationIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CoselmarUser.PROPERTY_ORGANIZATION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrganizationEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CoselmarUser.PROPERTY_ORGANIZATION, v);
        return result;
    }

    @Deprecated
    public E findByOrganization(String v) {
        return forOrganizationEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOrganization(String v) {
        return forOrganizationEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CoselmarUser.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CoselmarUser.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRoleIn(Collection<CoselmarUserRole> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CoselmarUser.PROPERTY_ROLE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRoleEquals(CoselmarUserRole v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CoselmarUser.PROPERTY_ROLE, v);
        return result;
    }

    @Deprecated
    public E findByRole(CoselmarUserRole v) {
        return forRoleEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRole(CoselmarUserRole v) {
        return forRoleEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == CoselmarUserGroup.class) {
            CoselmarUserGroupTopiaDao dao =
                topiaDaoSupplier.getDao(CoselmarUserGroup.class, CoselmarUserGroupTopiaDao.class);
            tmp = dao.forMembersContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Question.class) {
            QuestionTopiaDao dao =
                topiaDaoSupplier.getDao(Question.class, QuestionTopiaDao.class);
            tmp = dao.forSupervisorsContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Question.class) {
            QuestionTopiaDao dao =
                topiaDaoSupplier.getDao(Question.class, QuestionTopiaDao.class);
            tmp = dao.forContributorsContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Question.class) {
            QuestionTopiaDao dao =
                topiaDaoSupplier.getDao(Question.class, QuestionTopiaDao.class);
            tmp = dao.forClientsContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Document.class) {
            DocumentTopiaDao dao =
                topiaDaoSupplier.getDao(Document.class, DocumentTopiaDao.class);
            tmp = dao.forOwnerEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);

        List<? extends TopiaEntity> list;

        list = findUsages(CoselmarUserGroup.class, entity);
        if (!list.isEmpty()) {
            result.put(CoselmarUserGroup.class, list);
        }

        list = findUsages(Question.class, entity);
        if (!list.isEmpty()) {
            result.put(Question.class, list);
        }

        list = findUsages(Document.class, entity);
        if (!list.isEmpty()) {
            result.put(Document.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedCoselmarUserTopiaDao<E extends CoselmarUser>
