/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.content.AdminThesaurusHandler;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.*;
import com.jurismarches.vradi.ui.renderers.ThesaurusHighlighter;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusTreeTableHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ThesaurusCartographyUI extends javax.swing.JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_THESAURUS_HIGHLIGHTERS = "thesaurus.highlighters";
    public static final String BINDING_THESAURUS_TREE_TABLE_MODEL = "thesaurus.treeTableModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRBdm9jBzgcmVkKAAElIy5mKJlEIGEWJ5RAUBxThhrVvba9Z3y67c8mFAvET+AnQ0yDRUSEKagoaxF9AiIIWMXv+SuASLGLJPmtn35s3M2/u9TeSMJrMNWkQONr3gLeYU7i1s7NZabIq3GGmqrkCqUn7E4uTeJmMuL1zA+RquWjhuQ48l5ctJT3mHUAvFknawL5gpsEYALl0GFE1JlfqhRcD5esua09UFOvLH9/jL9znr+KEBArVDWEps/9C9SsZKpI4d4FMYKZdmhPUq6MMzb066h2zZ3lBjblLW+wJeUaGiySpqEYyIPODlxxyhPhAAZmCBjPU177JUw2yrqlq7N9fB3KjKltO09fctKiu4iVnV1OXOz53ZK3GtLMdCVQq5E4CGVsolKpaCnGPeuw6kHO2gMAxe1iPcyBkr6d6qFRPD5ArUtedJs72MUjVBgZOYWdbM7ZNKyJEjvaRC4XbPoD0MFf2UK72cSePJhcPTQRn7fRn3R9GrEwS2sdjINPlv+2xhaG2Mab/MIYlDKO/prKf3319u9p1QxpzT0ZePWBmnJLSUjEN3KY+07aCD1zkNqhaLJOUYQI3IXT6TISwUieM4jDfWQt3LNxZo6aBFInhL+8/TD36dIrEV0laSOquUnt/3bZeYxekcAN1cyVUNLp3Gn8zVhuQSZfVqC8gL6RhmyiRApcekPEllwKdrXDPxXYvB9iTmYie9IRVUh9/ZktvVrp9iaHO80de7/cm8ZAkuSe4x8I96axA5F6MKMN8V/atHmX+mH2mVcexF8Lfy1GFJwXdlz7Y+Fzg28d8KNv+WxiYJQEcBDpsYqldxCwF3O2KD2z5/0lTNZzANcOfhpU70USZAYhGG7zeEPgFps0xlQ7CNaKlhAfc8M6OnkBWBv24Z7aQb416Lm7jCfnGofvy2JAuEycsdIhX2++VIziyg3AAC+CYqizHbyBjetsWBwAA";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.ThesaurusCartographyUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected org.jdesktop.swingx.JXTreeTable thesaurus;
    protected ThesaurusCartographyUI thesaurusCartographyUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected ThesaurusTreeTableHelper helper;
    protected ThesaurusHighlighter highlighter;
    
    
    public  ThesaurusCartographyUI(jaxx.runtime.JAXXContext parentContext, ThesaurusTreeTableHelper helper) {
        jaxx.runtime.SwingUtil.initContext(this, parentContext);
        this.helper = helper;
        setContextValue(helper);
        jaxx.runtime.JAXXUtil.assignment(highlighter = new ThesaurusHighlighter(helper.getDataProvider()), "highlighter", com.jurismarches.vradi.ui.offer.ThesaurusCartographyUI.this);
    $initialize();
    }
    
    void $afterCompleteSetup() {
        thesaurus.putClientProperty("JTree.lineStyle", "Angled");
        final Action copyToClipboard = new AdminThesaurusHandler.CopyToClipboard(this);
    
        // Adding ridht clic menu
        thesaurus.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
    
    
                JPopupMenu popup = new JPopupMenu();
    
                // Add mouse listener to enable menus
                if (mouseEvent.getButton() == MouseEvent.BUTTON3){
                
                    popup.add(copyToClipboard);
    
                    popup.show(thesaurus, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    
        // Register tree table
        helper.setUI(thesaurus, true, false, null);
    
        // Single selection mode
        thesaurus.getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    
        // Expend on click
        UIHelper.addThesaurusExpandOnClickListener(thesaurus);
    
        // Render
        thesaurus.setTreeCellRenderer(highlighter);
    
        this.pack();
        
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
    
    public ThesaurusTreeTableHelper getHelper() {
        return helper;
    }
    
    protected void close() {
        UIHelper.saveComponentDispositionConfig();
        this.dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusCartographyUI() {
        $initialize();
    }

    public ThesaurusCartographyUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        close();
    }

    public void doWindowClosing__on__thesaurusCartographyUI(java.awt.event.WindowEvent event) {
        this.dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public org.jdesktop.swingx.JXTreeTable getThesaurus() {
        return thesaurus;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusCartographyUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JScrollPane0, BorderLayout.CENTER);
        add($JButton0, BorderLayout.SOUTH);
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new org.jdesktop.swingx.JXTreeTable());
        
        thesaurus.setName("thesaurus");
        if (thesaurus.getFont() != null) {
            thesaurus.setFont(thesaurus.getFont().deriveFont((float) 11));
        }
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToThesaurusCartographyUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurus);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("close"));
        // late initializer
        thesaurusCartographyUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("thesaurusCartographyUI", this);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurus();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.common.close"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of thesaurusCartographyUI
        setName("thesaurusCartographyUI");
        thesaurusCartographyUI.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.thesaurusCartographyUI.title"));
        thesaurusCartographyUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__thesaurusCartographyUI"));
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_HIGHLIGHTERS, true ,"highlighter") {
        
            @Override
            public void processDataBinding() {
                thesaurus.setHighlighters(highlighter);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_TREE_TABLE_MODEL, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    thesaurus.setTreeTableModel(helper.createTreeModel());
                }
            }
        });
    }

}