/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: FormTypeNavigationTreeHelper.java 1809 2010-11-25 15:26:00Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.1/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/helpers/FormTypeNavigationTreeHelper.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.helpers;

import java.util.Set;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiExtensionsListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jurismarches.vradi.ui.admin.loadors.FormTypeNodeLoadors;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import org.nuiton.wikitty.entities.WikittyExtension;


/**
 * @author letellier
 */
public class FormTypeNavigationTreeHelper extends AdminNavigationTreeHelper implements VradiExtensionsListener {

    /** Logger. */
    static private final Log log = LogFactory.getLog(FormTypeNavigationTreeHelper.class);

    public FormTypeNavigationTreeHelper(VradiDataProvider dataProvider) {
        super(dataProvider);
        VradiContext.get().getVradiNotifier().addVradiListener(this);
    }

    @Override
    public VradiTreeNode createNode() {

        // Create client category node
        return new VradiTreeNode(
                String.class,
                AdminBeanConstant.FORM_TYPE.getCategoryName(),
                null,
                new FormTypeNodeLoadors()
        );
    }

    @Override
    public void createEntityNode(String name) {
        createFormTypeNode(name, false);
    }

    @Override
    public void extensionsAdded(Set<WikittyExtension> added) {
        for (WikittyExtension ext : added) {

            // for putExtension, wikittyExtensions has only one element
            String name = ext.getName();

            if (log.isDebugEnabled()) {
                log.debug("search node with name " + name);
            }
            VradiTreeNode existingNode = findNode(getRootNode(), name);

            // cas modification
            if (existingNode != null) {
                refresh(existingNode);
            }

            // cas creation
            else {
                createEntityNode(name);
            }
        }
    }

    @Override
    public void extensionsRemoved(Set<String> removedName) {
        removeEntities(removedName);
    }

}
