/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class RequestSelectUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_QUERY_DESCRIPTION_TEXT = "queryDescription.text";
    public static final String BINDING_QUERY_DESCRIPTION_TOOL_TIP_TEXT = "queryDescription.toolTipText";
    public static final String BINDING_QUERY_NAME_TEXT = "queryName.text";
    public static final String BINDING_QUERY_NAME_TOOL_TIP_TEXT = "queryName.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_TOOL_TIP_TEXT = "$JButton0.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.RequestSelectUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.beans.QueryBean bean;
    protected javax.swing.JTextArea queryDescription;
    protected javax.swing.JTextField queryName;
    protected RequestSelectUI requestSelectUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    public void confirmDeletion() {
        com.jurismarches.vradi.beans.QueryBean queryBean = getBean();
        if (StringUtils.isBlank(queryBean.getName())
                && StringUtils.isBlank(queryBean.getDescription())
                && StringUtils.isBlank(queryBean.getQuery())) {
            setBean(null);
            
        } else {
            int confirm = JOptionPane.showConfirmDialog(this,
                    _("vradi.admin.confirmDelete", VradiHelper.getEntityName(getBean())),
                    _("vradi.admin.deleteTitle"), JOptionPane.YES_NO_OPTION);
        
            if (confirm == JOptionPane.YES_OPTION) {
                setBean(null);
            }
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public RequestSelectUI() {
        $initialize();
    }

    public RequestSelectUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().openRequest(this, getBean());
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        confirmDeletion();
    }

    public void doKeyReleased__on__queryDescription(java.awt.event.KeyEvent event) {
        setBean(getBean().setDescription(queryDescription.getText()));
    }

    public void doKeyReleased__on__queryName(java.awt.event.KeyEvent event) {
        setBean(getBean().setName(queryName.getText()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.beans.QueryBean getBean() {
        return bean;
    }

    public javax.swing.JTextArea getQueryDescription() {
        return queryDescription;
    }

    public javax.swing.JTextField getQueryName() {
        return queryName;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.beans.QueryBean newValue) {
        com.jurismarches.vradi.beans.QueryBean oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToRequestSelectUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.3, 0.0, 11, 2, new Insets(0, 6, 0, 0), 0, 0));
        add($JLabel1, new GridBagConstraints(1, 0, 3, 1, 0.7, 0.0, 11, 2, new Insets(0, 6, 0, 0), 0, 0));
        add(queryName, new GridBagConstraints(0, 1, 1, 1, 0.3, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton0, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton1, new GridBagConstraints(3, 1, 1, 1, 0.1, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.beans.QueryBean());
    }

    protected void createQueryDescription() {
        $objectMap.put("queryDescription", queryDescription = new javax.swing.JTextArea());
        
        queryDescription.setName("queryDescription");
        queryDescription.setColumns(15);
        queryDescription.setLineWrap(true);
        queryDescription.setWrapStyleWord(true);
        queryDescription.setRows(2);
        queryDescription.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__queryDescription"));
    }

    protected void createQueryName() {
        $objectMap.put("queryName", queryName = new javax.swing.JTextField());
        
        queryName.setName("queryName");
        queryName.setColumns(15);
        queryName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__queryName"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToRequestSelectUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(queryDescription);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("requestSelectUI", this);
        createBean();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.requestSelectUI.name"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.requestSelectUI.description"));
        createQueryName();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createQueryDescription();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminRequest.edit"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setToolTipText(_("vradi.adminRequest.remove"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of requestSelectUI
        setName("requestSelectUI");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_NAME_TOOL_TIP_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    queryName.setToolTipText(_(getBean().getQuery()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(queryName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_DESCRIPTION_TOOL_TIP_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    queryDescription.setToolTipText(_(getBean().getQuery()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_DESCRIPTION_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(queryDescription, getBean().getDescription());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_TOOL_TIP_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    $JButton0.setToolTipText(_(getBean().getQuery()));
                }
            }
        });
    }

}