/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.models.FieldSelectModel;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class FieldDisplayUI extends jaxx.runtime.swing.Table implements JAXXObject, jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_NAME_VALUE_FIELD_TEXT = "nameValueField.text";
    public static final String BINDING_TYPE_COMBO_SELECTED_ITEM = "typeCombo.selectedItem";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JTEXT_FIELD0_TEXT = "$JTextField0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.FieldDisplayUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.ui.admin.models.FieldSelectModel bean;
    protected FieldDisplayUI fieldDisplayUI = this;
    protected javax.swing.JTextField nameValueField;
    protected javax.swing.JComboBox typeCombo;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.admin.models.FieldSelectModel > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JTextField $JTextField0;
    private javax.swing.JLabel $JLabel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel contentPane;
    
    
    public void updateBean(FieldSelectModel model) {
        bean.update(model);
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public void setContentPane(JPanel contentPane){
        this.contentPane = contentPane;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FieldDisplayUI() {
        $initialize();
    }

    public FieldDisplayUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.admin.models.FieldSelectModel > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.ui.admin.models.FieldSelectModel getBean() {
        return bean;
    }

    public javax.swing.JTextField getNameValueField() {
        return nameValueField;
    }

    public javax.swing.JComboBox getTypeCombo() {
        return typeCombo;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("nameValue", nameValueField);
        validator.setFieldRepresentation("type", typeCombo);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JTextField get$JTextField0() {
        return $JTextField0;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFieldDisplayUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(nameValueField), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JTextField0, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel2, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(typeCombo), new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.ui.admin.models.FieldSelectModel());
    }

    protected void createNameValueField() {
        $objectMap.put("nameValueField", nameValueField = new javax.swing.JTextField());
        
        nameValueField.setName("nameValueField");
        nameValueField.setColumns(15);
        nameValueField.setEditable(false);
    }

    protected void createTypeCombo() {
        $objectMap.put("typeCombo", typeCombo = new javax.swing.JComboBox());
        
        typeCombo.setName("typeCombo");
        typeCombo.setEnabled(false);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.admin.models.FieldSelectModel >(com.jurismarches.vradi.ui.admin.models.FieldSelectModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToFieldDisplayUI();
        addChildrenToValidator();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        nameValueField.setBackground(new Color(229, 229, 229));
        $JTextField0.setBackground(new Color(229, 229, 229));
        typeCombo.setModel(getHandler().getTypesModel());
        typeCombo.setRenderer(UIHelper.getTranslationListCellRenderer());
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("fieldDisplayUI", this);
        createBean();
        createValidator();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminField.name"));
        createNameValueField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminField.desc"));
        // inline creation of $JTextField0
        $objectMap.put("$JTextField0", $JTextField0 = new javax.swing.JTextField());
        
        $JTextField0.setName("$JTextField0");
        $JTextField0.setColumns(15);
        $JTextField0.setEditable(false);
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminField.type"));
        createTypeCombo();
        // inline creation of fieldDisplayUI
        setName("fieldDisplayUI");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_VALUE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("nameValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText(nameValueField, bean.getNameValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("nameValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JTEXT_FIELD0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("descValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    jaxx.runtime.SwingUtil.setText($JTextField0, bean.getDescValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("descValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TYPE_COMBO_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (bean != null) {
                    bean.addPropertyChangeListener("type", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    typeCombo.setSelectedItem(bean.getType());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (bean != null) {
                    bean.removePropertyChangeListener("type", this);
                }
            }
        });
    }

}