/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.widget.UserListSelectorHandler;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.renderers.EntityRenderer;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminGroupUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<Group> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_GROUP_USER_HANDLER = "groupUserHandler";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CREATE_BUTTON_ENABLED = "createButton.enabled";
    public static final String BINDING_GROUP_NAME_TEXT = "groupName.text";
    public static final String BINDING_REQUEST_LIST_UI_BEAN = "requestListUI.bean";
    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminGroupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table adminGroupForm;
    protected com.jurismarches.vradi.entities.Group bean;
    protected javax.swing.JButton createButton;
    protected javax.swing.JTextField groupName;
    protected com.jurismarches.vradi.ui.admin.widget.UserListSelectorHandler groupUserHandler;
    protected jaxx.runtime.swing.ListSelectorUI< User > groupUsers;
    protected com.jurismarches.vradi.ui.admin.content.RequestListUI requestListUI;
    protected javax.swing.JLabel title;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Group > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminGroupUI $AdminContentUI0 = this;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
    
        AutoCompleteDecorator.decorate(groupUsers.getCombo(), EntityRenderer.getInstance());
    
        groupUsers.addPropertyChangeListener("modified", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from users");
                    setModified(true);
                }
            }
        });
        errorTable.registerValidator(validator);
    
        groupUserHandler = new UserListSelectorHandler(groupUsers);
        groupUsers.setHandler(groupUserHandler);
    }
    
    /**
     * Fill groups and users ListSelectorUI.
     */
    @Override
    protected void postLoadBean() {
    
        createButton.setEnabled(!isInCreation());
    
        requestListUI.setBean(bean);
        groupUserHandler.setBean(bean);
        if (bean == null) {
    
            // Clear all user
            groupUsers.init(Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    
            // Clear all requests
            requestListUI.init();
    
            return;
        }
    
        Set<String> users = bean.getUser();
    
        java.util.List<User> toUserList = new java.util.ArrayList<User>();
        if (users != null){
            toUserList = VradiService.getWikittyProxy().restore(User.class, new ArrayList<String>(users));
        }
    
        java.util.List<User> toUserCombo = new java.util.ArrayList<User>(getHandler().getAllUsers());
    
        toUserCombo.removeAll(toUserList);
    
        // Sort
        Collections.sort(toUserList, VradiComparators.USER_COMPARATOR);
    
        groupUsers.init(toUserCombo, toUserList);
    
        requestListUI.setBean(bean);
        requestListUI.init();
        groupUserHandler.setBean(bean);
    }
    
    @Override
    public void save() {
        setModified(false);
    
        //Use new list to avoid empty queries after clearing
        Group bean = requestListUI.getBean();
        java.util.List<String> queries = null;
        if (bean.getQueries()!=null){
            queries = new java.util.ArrayList<String>(requestListUI.getBean().getQueries());
        }
    
        //Store queries
        bean.clearQueries();
        if (queries!=null){
            for (String query : queries) {
                bean.addQueries(query);
            }
        }
    
        //Store users
        bean.clearUser();
        for (User user : groupUsers.getListDatas()) {
            log.debug("Store user : " + user.getName());
            bean.addUser(user.getWikittyId());
        }
    
        //Set modified to false just before saving to avoid multiple confirmation
        setModified(false);
        Group group = getHandler().saveGroup(this, getHelper(), bean);
    
    
        //FIXME JC 25/08/2010 bean is the same (because of cache ?) so no property change fired. Set bean to null before to force fire.
        setModified(false);
        setBean(null);
        setBean(group);
    
        groupUsers.setModified(false);
    }
    
    @Override
    protected void clearUI() {
        title.setText(updateTitle(""));
        groupName.setText("");
        groupUsers.init(null, null);
    }
    
    protected String updateTitle(String name) {
        return _("vradi.adminGroup.title", getStringValue(name));
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminGroupUI() {
        super();
        $initialize();
    }

    public AdminGroupUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Group > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__createButton(java.awt.event.ActionEvent event) {
        getHandler().createGroup(this);setModified(true);
    }

    public void doKeyReleased__on__groupName(java.awt.event.KeyEvent event) {
        getBean().setName(groupName.getText());                                                title.setText(updateTitle(getBean().getName()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminGroupForm() {
        return adminGroupForm;
    }

    public com.jurismarches.vradi.entities.Group getBean() {
        return bean;
    }

    public javax.swing.JButton getCreateButton() {
        return createButton;
    }

    public javax.swing.JTextField getGroupName() {
        return groupName;
    }

    public com.jurismarches.vradi.ui.admin.widget.UserListSelectorHandler getGroupUserHandler() {
        return groupUserHandler;
    }

    public jaxx.runtime.swing.ListSelectorUI< User > getGroupUsers() {
        return groupUsers;
    }

    public com.jurismarches.vradi.ui.admin.content.RequestListUI getRequestListUI() {
        return requestListUI;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Group newValue) {
        com.jurismarches.vradi.entities.Group oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    public void setGroupUserHandler(com.jurismarches.vradi.ui.admin.widget.UserListSelectorHandler newValue) {
        com.jurismarches.vradi.ui.admin.widget.UserListSelectorHandler oldValue = this.groupUserHandler;
        this.groupUserHandler = newValue;
        firePropertyChange(PROPERTY_GROUP_USER_HANDLER, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("name", groupName);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminGroupForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminGroupForm.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(SwingUtil.boxComponentWithJxLayer(groupName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(groupUsers, new GridBagConstraints(1, 1, 1, 1, 1.0, 2.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(requestListUI, new GridBagConstraints(0, 2, 2, 1, 1.0, 3.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminGroupForm, BorderLayout.CENTER);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
    }

    protected void createAdminGroupForm() {
        $objectMap.put("adminGroupForm", adminGroupForm = new jaxx.runtime.swing.Table());
        
        adminGroupForm.setName("adminGroupForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCreateButton() {
        $objectMap.put("createButton", createButton = new javax.swing.JButton());
        
        createButton.setName("createButton");
        createButton.setText(_("vradi.adminGroup.createGroup"));
        createButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createButton"));
    }

    protected void createGroupName() {
        $objectMap.put("groupName", groupName = new javax.swing.JTextField());
        
        groupName.setName("groupName");
        groupName.setColumns(15);
        groupName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__groupName"));
    }

    protected void createGroupUserHandler() {
        $objectMap.put("groupUserHandler", groupUserHandler = null);
    }

    protected void createGroupUsers() {
        $objectMap.put("groupUsers", groupUsers = new jaxx.runtime.swing.ListSelectorUI< User >());
        
        groupUsers.setName("groupUsers");
        groupUsers.setShowHidor(false);
        ((javax.swing.JToolBar) groupUsers.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) groupUsers.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createRequestListUI() {
        $objectMap.put("requestListUI", requestListUI = new com.jurismarches.vradi.ui.admin.content.RequestListUI(this));
        
        requestListUI.setName("requestListUI");
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Group >(com.jurismarches.vradi.entities.Group.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createButton);
        $JPanel0.add($JButton0);
        addChildrenToBody();
        addChildrenToAdminGroupForm();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        createButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("group.add"));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("group.delete"));
        groupUsers.setAddToComboTip(_("vradi.adminGroup.removeUser"));
        groupUsers.setAddToListTip(_("vradi.adminGroup.addUser"));
        groupUsers.setHandler(groupUserHandler);
        groupUsers.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$AdminContentUI0", this);
        createValidator();
        createBean();
        createGroupUserHandler();
        createTitle();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreateButton();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("vradi.adminClient.deleteGroup"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createAdminGroupForm();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminGroup.name"));
        createGroupName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminGroup.listUsers"));
        createGroupUsers();
        createRequestListUI();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((jaxx.runtime.swing.Table) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    title.setText(_(updateTitle(getBean().getName())));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_BUTTON_ENABLED, true ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                createButton.setEnabled(!isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled() && !isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GROUP_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(groupName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REQUEST_LIST_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                requestListUI.setBean(getBean());
            }
        });
    }

}