/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: VradiMainUIHandler.java 1844 2010-12-22 14:30:09Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.1/vradi-swing/src/main/java/com/jurismarches/vradi/ui/VradiMainUIHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui;

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

import com.jurismarches.vradi.VradiConfigHelper;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

import com.jurismarches.vradi.VradiHelper;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.context.DefaultApplicationContext.AutoLoad;
import jaxx.runtime.swing.AboutPanel;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.editor.config.ConfigUIHelper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.TimeTrace;
import org.nuiton.widget.SwingSession;

import com.jurismarches.vradi.VradiConfig;
import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.email.EmailHandler;
import com.jurismarches.vradi.ui.email.EmailPopupUI;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import com.jurismarches.vradi.ui.offer.OfferEditHandler;
import com.jurismarches.vradi.ui.offer.OfferListHandler;
import com.jurismarches.vradi.ui.offer.OfferListUI;
import com.jurismarches.vradi.ui.task.VradiTask;
import java.util.Map;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.WikittyExtension;

/**
 * Le handler de l'ui principale.
 *
 * @author chemit
 * @see VradiMainUI
 */
@AutoLoad
public class VradiMainUIHandler { //implements JAXXHelp {

    /**
     * to use log facility, just put in your code: log.info(\"...\");
     */
    static private Log log = LogFactory.getLog(VradiMainUIHandler.class);

    static public final String XML_FILE_EXTENSION = ".xml";

    /**
     * Methode pour initialiser l'ui principale sans l'afficher.
     *
     * @param rootContext le context applicatif
     * @param fullscreen  flag pour indiquer si on doit ouvrir l'ui en model console (pleine ecran).
     * @return l'ui instancie et initialisee mais non visible encore
     */
    public VradiMainUI initUI(JAXXContext rootContext, boolean fullscreen) {

        JAXXInitialContext context = new JAXXInitialContext().add(rootContext);

        // Init swingSession
        VradiConfig config = VradiContext.get().getVradiConfig();
        SwingSession swingSession = new SwingSession(VradiConfigHelper.getSwingConfigFile(config), false);
        VradiContext.SWING_SESSION_ENTRY_DEF.setContextValue(VradiContext.get(), swingSession);

        // show main ui
        final VradiMainUI ui = new VradiMainUI(context);

        VradiContext.MAIN_UI_ENTRY_DEF.setContextValue(VradiContext.get(), ui);
        
        ErrorDialogUI.init(ui);

        // set fullscreen propery on main ui
        if (fullscreen) {
            ui.getGraphicsConfiguration().getDevice().setFullScreenWindow(ui);
        }
        
        // init home screen
        OfferListHandler handler = UIHelper.getHandler(context, OfferListHandler.class);

        OfferListUI content = handler.initUI(ui);

        ui.setContentPane(content);

        ui.pack();
            
        ui.setVisible(true);

        // Add this frame
        swingSession.add(ui);
        swingSession.save();

        // Saved in context
        VradiContext.OFFERT_LIST_UI_ENTRY_DEF.setContextValue(VradiContext.get(), content);

        // Must be always hide on init
        content.setDividerLocation(Integer.MAX_VALUE);
        content.setDividerSize(0);
        
        return ui;
    }

    public void changeContent(JAXXContext context, JComponent content) {
        VradiMainUI ui = getUI(context);
        ui.setContentPane(content);
        ui.setVisible(true);
    }

    public void edit(JAXXContext context, Form data) {
        OfferEditHandler handler = UIHelper.getHandler(context, OfferEditHandler.class);
        changeContent(VradiContext.get(), handler.initUI(context, data.getWikittyId()));
    }

    public void goToHome(JAXXContext context) {
        OfferListHandler handler = UIHelper.getHandler(context, OfferListHandler.class);
        changeContent(context, handler.initUI(context));
    }

    public void changeLanguage(VradiMainUI mainUI, Locale newLocale) {
        VradiConfig config = mainUI.getConfig();
        // sauvegarde de la nouvelle locale
        VradiConfigHelper.setLocale(config, newLocale);
        // chargement de la nouvelle locale dans le système i18n
        I18n.init(newLocale);
        // on recharge les decorateurs
        //DecoratorProvider decoratorProvider = mainUI.getContextValue(DecoratorProvider.class);
        //decoratorProvider.reloadCache();
        // on recharge l'ui
        reloadUI(VradiContext.get(), VradiConfigHelper.isFullScreen(config));
    }

    /**
     * Ferme l'application.
     *
     * @param ui l'ui principale de l'application
     */
    public void close(VradiMainUI ui) {
        log.info("Vradi quitting...");

        // Close all tabs before save
        UIHelper.getHandler(ui, OfferListHandler.class).closeAllTabs();

        // Store session configuration
        UIHelper.saveComponentDispositionConfig();

        boolean canContinue = ensureModification(ui);
        if (!canContinue) {
            return;
        }
        try {
            ui.dispose();
        } finally {
            System.exit(0);
        }
    }

    /**
     * Méthode pour changer de mode d'affichage.
     * <p/>
     * Si <code>fullscreen</code> est à <code>true</code> alors on passe en
     * mode console (c'est à dire en mode plein écran exclusif), sinon on
     * passe en mode fenetré normal.
     *
     * @param ui         l'ui principale de l'application
     * @param fullscreen le nouvel état requis.
     */
    public void changeScreen(VradiMainUI ui, final boolean fullscreen) {
        boolean canContinue = ensureModification(ui);
        if (!canContinue) {
            return;
        }
        VradiConfigHelper.setFullscreen(ui.getConfig(), fullscreen);

        reloadUI(VradiContext.get(), fullscreen);
    }

    /**
     * Open admin popups and set specified selected tab index.
     * 
     * @param rootContext
     * @param tabIndex selected tab index
     */
    protected void openAdminPopup(VradiMainUI rootContext, int tabIndex) {
        AdminHandler handler = UIHelper.getHandler(rootContext, AdminHandler.class);
        AdminPopupUI ui = handler.init(rootContext);

        ui.showTab(tabIndex);
        ui.setLocationRelativeTo(rootContext);
        ui.setVisible(true);
    }

    protected void openEmailPopup(VradiMainUI rootContext) {
        EmailPopupUI ui = UIHelper.getHandler(rootContext, EmailHandler.class).init(rootContext);
        ui.setLocationRelativeTo(rootContext);
        ui.setVisible(true);
    }

    public void showAdminClient(VradiMainUI context) {
        openAdminPopup(context, 0);
    }

    public void showAdminGroup(VradiMainUI context) {
        openAdminPopup(context, 1);
    }

    public void showAdminForm(VradiMainUI context) {
        openAdminPopup(context, 2);
    }

    public void showAdminXmlStream(VradiMainUI context) {
        openAdminPopup(context, 3);
    }

    public void showAdminThesaurus(VradiMainUI context) {
        openAdminPopup(context, 5);
    }

    public void showAdminStatus(VradiMainUI context) {
        openAdminPopup(context, 4);
    }

    public void showEmail(VradiMainUI context) {
        openEmailPopup(context);
    }

    /*public void showExport(JAXXContext rootContext) {
        final VradiMainUI mainUI = getUI(rootContext);
        final File file = UIHelper.openFileChooser(XML_FILE_EXTENSION, "vradi.export.filter.xml", mainUI, "vradi.export.validate.label");

        if (file != null) {
            VradiTask<Void> task = new VradiTask<Void>(mainUI) {

                @Override
                public Void doAction() throws Exception {
                    String s = VradiService.getVradiStorageService().exportData();
                    FileUtil.writeString(file, s, "UTF-8");
                    return null;
                }
            };
            task.execute();
        }
    }

    public void showImport(JAXXContext rootContext) {
        final VradiMainUI mainUI = getUI(rootContext);
        final File file = UIHelper.openFileChooser(XML_FILE_EXTENSION, "vradi.export.filter.xml", mainUI, "vradi.import.validate.label");
        if (file != null) {
            VradiTask<Void> task = new VradiTask<Void>(mainUI) {

                @Override
                public Void doAction() throws Exception {
                    VradiService.getVradiStorageService().importData(file);
                    return null;
                }
            };
            task.execute();
        }

    }*/

    public void showReindex(JAXXContext rootContext) {
        final VradiMainUI mainUI = getUI(rootContext);
        mainUI.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        int answer = JOptionPane.showConfirmDialog(mainUI, _("vradi.reindex.message"), _("vradi.reindex.title"),
                JOptionPane.YES_NO_OPTION);
        if (answer == JOptionPane.YES_OPTION) {
            VradiTask<Void> task = new VradiTask<Void>(mainUI) {
                @Override
                public Void doAction() throws Exception {
                    VradiService.getVradiStorageService().reindexData();
                    return null;
                }
            };
            task.execute();
        }
    }

    public void showOfferListUI(JAXXContext context) {
        final JFrame offerListFrame = new JFrame(_("vradi.title.welcome")) {
            
        };

        offerListFrame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        offerListFrame.addWindowListener(new WindowAdapter() {

            @Override
            public void windowClosed(WindowEvent e) {
                UIHelper.saveComponentDispositionConfig();
                offerListFrame.dispose();
            }
        });
        UIHelper.registerComponentToSaveDispositionConfig(offerListFrame);

        // init home screen
        OfferListHandler handler = UIHelper.getHandler(context, OfferListHandler.class);
        OfferListUI ui = handler.initUI(context);
        offerListFrame.setContentPane(ui);
        offerListFrame.pack();
        offerListFrame.setVisible(true);
    }

    public void showConfig(JAXXContext context) {
        VradiMainUI ui = getUI(context);
        VradiConfig config = context.getContextValue(VradiConfig.class);

        // categorie repertoires
        ConfigUIHelper modelBuilder = new ConfigUIHelper(config);
        
        // category 1
        modelBuilder.addCategory(n_("vradi.config.category.directories"),
                n_("vradi.config.category.directories.description"));
        modelBuilder.addOption(VradiConfig.VradiSwingOption.CONFIG_FILE);
        
        // category 2
        modelBuilder.addCategory(n_("vradi.config.category.other"),
                n_("vradi.config.category.other.description"));
        modelBuilder.addOption(VradiConfig.VradiSwingOption.FULL_SCREEN);
        modelBuilder.addOption(VradiConfig.VradiSwingOption.LOCALE);
        
        // category 3
        modelBuilder.addCategory(n_("vradi.config.category.remote"),
                n_("vradi.config.category.remote.description"));
        modelBuilder.addOption(VradiConfig.VradiSwingOption.REMOTE_ENDPOINT);
        
        modelBuilder.buildUI(context, "vradi.config.category.directories");

        modelBuilder.displayUI(ui, false);
    }

    //    @Override
    public void showHelp(JAXXContext context, String helpId) {
//        VradiMainUI mainUI = getUI(context);
//
//        ObserveHelpBroker helpBroker = context.getContextValue(ObserveHelpBroker.class);
//
//        if (helpId == null) {
//            helpId = helpBroker.getDefaultID();
//        }
//        log.debug("show help " + helpId);
//        mainUI.getHelp().setCurrentID(helpId);
//
//        mainUI.setContextValue(mainUI.getMode(), "oldMode");
//        mainUI.setMode(ObserveUIMode.HELP);
    }

    public void closeHelp(JAXXContext context) {
//        VradiMainUI mainUI = getUI(context);
//        ObserveUIMode oldMode = mainUI.getContextValue(ObserveUIMode.class, "oldMode");
//        if (oldMode == null) {
//            // on regarde si une base est chargee
//            ObserveDataContext dataContext = context.getContextValue(ObserveDataContext.class);
//            StorageService<?> mainStorage = dataContext.getStorage();
//
//            if (mainStorage == null) {
//                oldMode = ObserveUIMode.NO_DB;
//            } else {
//                oldMode = ObserveUIMode.DB;
//            }
//        }
//        mainUI.setMode(oldMode);
    }

    public void gotoSite(JAXXContext rootContext) {

        VradiConfig config = rootContext.getContextValue(VradiConfig.class);

        URL siteURL = config.getOptionAsURL("application.site.url");

//        UIHelper.displayInfo(rootContext, _("vradi.message.goto.site", siteURL));

        log.debug("goto " + siteURL);
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(siteURL.toURI());
            } catch (Exception ex) {
                log.error(ex.getMessage(), ex);
                ErrorDialogUI.showError(ex);
            }
        }
    }

    public void showAbout(VradiMainUI ui) {
        AboutPanel about = new AboutPanel() {

            private static final long serialVersionUID = 1L;

//            @Override
//            public void buildTopPanel() {
//                topPanel.setLayout(new BorderLayout());
//                JLabel labelIcon;
//                Icon logoIcon;
//                logoIcon = Resource.getIcon("/icons/logo-OT_web.png");
//                labelIcon = new JLabel(logoIcon);
//                topPanel.add(labelIcon, BorderLayout.WEST);
//
//                logoIcon = Resource.getIcon("/icons/logo_ird.png");
//                labelIcon = new JLabel(logoIcon);
//                topPanel.add(labelIcon, BorderLayout.EAST);
//            }
        };

        about.setTitle(_("vradi.title.about"));
        ChangeLogHandler clh = UIHelper.getHandler(ui, ChangeLogHandler.class);
        about.setAboutText(clh.getLatestChangeLog());

        String copyright = VradiConfigHelper.getCopyrightText(ui.getConfig());
        about.setBottomText(copyright);
//        about.setIconPath("/icons/logo-OT_web.png");
        about.setLicenseFile("META-INF/vradi-swing-LICENSE.txt");
        about.setThirdpartyFile("META-INF/vradi-swing-THIRD-PARTY.txt");
        about.init();
        about.showInDialog(ui, true);
    }

    public void showStat(VradiMainUI ui) {
        String msg = "Proxy call statistics\n";
        for(Map.Entry<String, TimeTrace.CallStat> e : WikittyProxy.getCallCount().entrySet()) {
            msg += "\n\t" + e.getKey() + " = " + e.getValue();
        }
        if (log.isInfoEnabled()) {
            log.info(msg);
        }
        JOptionPane.showMessageDialog(ui, msg);
    }

    /**
     * Permet de recharger l'ui principale et de changer de le mode d'affichage.
     *
     * @param rootContext le contexte applicatif
     * @param fullscreen  le type de fenetre à reouvrir
     */
    protected void reloadUI(VradiContext rootContext, boolean fullscreen) {

        // must remove all properties listener on config
        rootContext.getContextValue(VradiConfig.class).removeJaxxPropertyChangeListener();

        // scan main ui
        VradiMainUI ui = getUI(rootContext);

        if (ui != null) {

            ErrorDialogUI.init(null);

            VradiContext.MAIN_UI_ENTRY_DEF.removeContextValue(rootContext);
            VradiContext.ADMIN_UI_ENTRY_DEF.removeContextValue(rootContext);

            ui.dispose();

            ui.setVisible(false);
        }

        ui = initUI(rootContext, fullscreen);

        // show ui
        ui.setVisible(true);
    }

    /**
     * Test if there is some modification on screen,
     *
     * @param rootContext the context
     * @return <code>true</code> if no more modification is detected
     * @throws IllegalArgumentException if rootContext is null
     */
    protected boolean ensureModification(JAXXContext rootContext) throws IllegalArgumentException {
        if (rootContext == null) {
            throw new IllegalArgumentException("rootContext can not be null");
        }
        VradiMainUI ui = getUI(rootContext);
        if (ui == null) {
            // no ui, so no modification
            return true;
        }
        // check ui is not modified
        return true;
    }

    VradiMainUI getUI(JAXXContext context) {
        if (context instanceof VradiMainUI) {
            return (VradiMainUI) context;
        }
        VradiMainUI ui = VradiContext.MAIN_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }


    public void createForm(WikittyExtension extension) {
        OfferListUI ui = VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(VradiContext.get());

        if (ui != null) {
            log.debug("FormType selected : " + extension);

            // If is canceled
            if (extension == null) {
                return;
            }
            FormImpl formImpl = new FormImpl();
            formImpl.getWikitty().addExtension(extension);

            Form form = VradiHelper.initForm(formImpl);

            if (log.isDebugEnabled()) {
                log.debug("Creating form with id : " + form.getWikittyId());
            }

            ui.getHandler().addEditPane(ui.getDelegateContext(), form);
        }
    }
}
