/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: GroupNavigationTreeHelper.java 1841 2010-12-22 09:58:23Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/helpers/GroupNavigationTreeHelper.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.helpers;

import java.util.*;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiEntitiesListener;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.ui.admin.loadors.GroupUsersNodeLoadors;
import com.jurismarches.vradi.ui.admin.loadors.GroupsNodeLoadors;
import jaxx.runtime.swing.nav.NavHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;

/**
 * @author letellier
 */
public class GroupNavigationTreeHelper extends AdminNavigationTreeHelper<Group> {

    /** Logger. */
    static private final Log log = LogFactory.getLog(GroupNavigationTreeHelper.class);

    protected VradiEntitiesListener<User> userVradiEntitiesListener;

    public GroupNavigationTreeHelper(VradiDataProvider dataProvider) {
        super(dataProvider);
        VradiContext.get().getVradiNotifier().addVradiListener(Group.class, this);
        userVradiEntitiesListener = new VradiEntitiesListener<User>() {

            @Override
            public void entitiesAdded(Set<User> added) {
                for (User user : added) {

                    String wikittyId = user.getWikittyId();

                    // cas creation
                    VradiTreeNode existingNode = findNode(getRootNode(), wikittyId);

                    // cas modification
                    if (existingNode != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("User modification occured");
                        }
                        // Reconstruction des fils
                        refresh(existingNode);
                    }
                }
            }

            @Override
            public void entitiesRemoved(Set<String> removedIds) {
                removeEntities(removedIds);
            }
        };
        VradiContext.get().getVradiNotifier().addVradiListener(User.class, userVradiEntitiesListener);
    }

    @Override
    public VradiTreeNode createNode() {
        return new VradiTreeNode(
                String.class,
                AdminBeanConstant.GROUP.getCategoryName(),
                null,
                new GroupsNodeLoadors()
        );
    }

    @Override
    public void createEntityNode(String wikittyId) {
        createGroupNode(wikittyId, false);
    }

    /*
    * @see org.nuiton.wikitty.WikittyServiceListener#putWikitty(org.nuiton.wikitty.WikittyServiceEvent)
    */
    @Override
    public void entitiesAdded(Set<Group> added) {
        if (log.isDebugEnabled()) {
            log.debug("Groups added");
        }

        for (Group group : added) {
            String wikittyId = group.getWikittyId();
            VradiTreeNode existingNode = findNode(getRootNode(), wikittyId);

            // cas modification
            if (existingNode != null) {

                // Refresh
                refresh(existingNode);

                // Add missing users
                Set<String> userIds = group.getUser();

                // Remove old users
                VradiTreeNode userCategory = findNode(existingNode, AdminBeanConstant.USER.getCategoryName());
                if (userCategory != null) {
                    Enumeration<VradiTreeNode> childrenEnum = userCategory.children();
                    while (childrenEnum.hasMoreElements()) {
                        VradiTreeNode child = childrenEnum.nextElement();

                        if (userIds == null || !userIds.contains(child.getId())) {
                            removeNode(child);
                        }
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("User category not found");
                    }

                    // Create users category node
                    userCategory = new VradiTreeNode(
                            String.class,
                            AdminBeanConstant.USER.getCategoryName(),
                            null,
                            NavHelper.getChildLoador(GroupUsersNodeLoadors.class)
                    );
                    insertNode(existingNode, userCategory);
                    return;
                }
                if (userIds != null) {
                    for (String userId : userIds) {
                        VradiTreeNode userNode = findNode(existingNode, userId);
                        if (userNode == null) {

                            // Create user node
                            userNode = new VradiTreeNode(User.class, userId, null, null);
                            insertNode(userCategory, userNode);

                            if (log.isDebugEnabled()) {
                                log.debug("Create user node");
                            }
                        }
                    }
                }
            }

            // cas creation
            else {
                if (log.isDebugEnabled()) {
                    log.debug("Create group node");
                }
                createEntityNode(wikittyId);
            }
        }
    }
}
