/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.helpers;

import com.jurismarches.vradi.ui.admin.helpers.AdminBeanConstant;
import com.jurismarches.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.loadors.FormTypeNodeLoadors;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyServiceEvent;

public class FormTypeNavigationTreeHelper
extends AdminNavigationTreeHelper {
    private static final Log log = LogFactory.getLog(FormTypeNavigationTreeHelper.class);

    public FormTypeNavigationTreeHelper(VradiDataProvider dataProvider) {
        super(dataProvider);
    }

    @Override
    public VradiTreeNode createNode() {
        return new VradiTreeNode(String.class, AdminBeanConstant.FORM_TYPE.getCategoryName(), null, new FormTypeNodeLoadors());
    }

    @Override
    public void putExtension(WikittyServiceEvent event) {
        Set extentionsId = event.getIds();
        Map wikittiesExtensions = event.getIdExtensions();
        for (String extentionId : extentionsId) {
            Set wikittyExtensions = (Set)wikittiesExtensions.get(extentionId);
            if (wikittyExtensions.contains("Form")) {
                VradiTreeNode existingNode;
                String name = WikittyExtension.computeName((String)extentionId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("search node with name " + name));
                }
                if ((existingNode = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{name})) != null) {
                    this.refresh(existingNode);
                    continue;
                }
                this.createFormTypeNode(name, false);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Can't manage event : " + extentionId + " ( " + wikittyExtensions + " )"));
        }
    }
}

