/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: TemplateFieldTableModel.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://tchemit@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/models/TemplateFieldTableModel.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.models;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.table.AbstractTableModel;
import java.util.*;

/**
 * Le modèle du tableau pour afficher et éditer les bindings d'un template OpenOffice.
 * <p/>
 * User: kmorin
 */
public class TemplateFieldTableModel extends AbstractTableModel {

    private static final long serialVersionUID = 1L;

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(TemplateFieldTableModel.class);
    /**
     * Liste des bindings à afficher
     */
    protected List<Map.Entry<String, String>> data;
    /**
     * Un drapeau pour bloquer le déclanchement des fireXXX)
     */
    protected boolean valueIsAdjusting;

    public TemplateFieldTableModel() {
        data = new ArrayList<Map.Entry<String, String>>();
    }

    @Override
    public int getRowCount() {
        return data.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    /**
     * Pour vider le modèle.
     */
    public void clear() {
        data.clear();
        if (!valueIsAdjusting) {
            fireTableDataChanged();
        }
    }

    public boolean isValueIsAdjusting() {
        return valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
    }

    /**
     * @return une copie de la liste des bindings
     */
    public Map<String, String> getData() {
        // always send a copy
        Map<String, String> result = new HashMap<String,String>();
        for (Map.Entry<String, String> entry : data) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public void setData(Map<String, String> data) {
        // always send a copy
        this.data.addAll(data.entrySet());
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ensureColumnIndex(columnIndex);
        ensureRowIndex(rowIndex);
        Map.Entry<String,String> entry = data.get(rowIndex);
        Object result = null;
        switch (columnIndex) {
            case 0:
                result = entry.getKey();
                break;
            case 1:
                String value = entry.getValue();
                if (value != null) {
                    result = Collections.singletonList(value);
                } 
                break;
        }
        return result;
    }

    @Override
    public void setValueAt(Object sValue, int rowIndex, int columnIndex) {
        ensureColumnIndex(columnIndex);
        ensureRowIndex(rowIndex);
        Map.Entry<String,String> entry = data.get(rowIndex);
        Object[] value = (Object[]) sValue;
        entry.setValue(value.length > 0 ? (String)value[0] : null);
        
        fireTableCellUpdated(rowIndex, columnIndex);
    }

    protected void ensureRowIndex(int rowIndex) {
        if (rowIndex >= getRowCount()) {
            throw new ArrayIndexOutOfBoundsException("rowIndex (" + rowIndex + ") can not be greater than " + getRowCount());
        }
    }

    protected void ensureColumnIndex(int columnIndex) {
        if (columnIndex >= getColumnCount()) {
            throw new ArrayIndexOutOfBoundsException("columnIndex (" + columnIndex + ") can not be greater than " + getColumnCount());
        }
    }

}