/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.models;

import com.jurismarches.vradi.ui.admin.AdminContentUI;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.AdminNavUI;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.Container;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class AdminTreeSelectionModel
extends DefaultTreeSelectionModel {
    protected AdminHandler handler;
    protected AdminNavUI ui;

    public AdminTreeSelectionModel(AdminNavUI ui, AdminHandler handler) {
        this.handler = handler;
        this.ui = ui;
    }

    @Override
    public void setSelectionPath(TreePath path) {
        if (this.willContinueSelection()) {
            super.setSelectionPath(path);
            this.afterSelection(path);
        }
    }

    @Override
    public void setSelectionPaths(TreePath[] pPaths) {
        if (this.willContinueSelection()) {
            super.setSelectionPaths(pPaths);
        }
    }

    @Override
    public void addSelectionPath(TreePath path) {
        if (this.willContinueSelection()) {
            super.addSelectionPath(path);
            this.afterSelection(path);
        }
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        if (this.willContinueSelection()) {
            super.addSelectionPaths(paths);
        }
    }

    @Override
    public void removeSelectionPath(TreePath path) {
        if (this.willContinueSelection()) {
            super.removeSelectionPath(path);
        }
        this.checkEmptySelection();
    }

    @Override
    public void removeSelectionPaths(TreePath[] paths) {
        if (this.willContinueSelection()) {
            super.removeSelectionPaths(paths);
        }
        this.checkEmptySelection();
    }

    @Override
    public void clearSelection() {
        if (this.willContinueSelection()) {
            super.clearSelection();
        }
        this.checkEmptySelection();
    }

    protected boolean willContinueSelection() {
        VradiTreeNode node;
        boolean canContinue;
        if (this.isSelectionEmpty()) {
            return true;
        }
        AdminContentUI contentUI = this.ui.getCurrentContent();
        return contentUI == null || contentUI.isModified() == false || (canContinue = this.handler.answerToSave(contentUI, node = (VradiTreeNode)((Object)this.getSelectionPath().getLastPathComponent())));
    }

    protected void afterSelection(TreePath path) {
        VradiTreeNode node = (VradiTreeNode)((Object)path.getLastPathComponent());
        this.handler.openUI(this.ui, node);
    }

    protected void checkEmptySelection() {
        if (this.isSelectionEmpty()) {
            this.ui.getContentLayout().show((Container)this.ui.getContent(), "none");
            return;
        }
    }
}

