/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.helpers;

import au.com.bytecode.opencsv.CSVWriter;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.models.EntityModel;
import com.jurismarches.vradi.ui.models.FormTypeModel;
import com.jurismarches.vradi.ui.offer.OfferEditHandler;
import com.jurismarches.vradi.ui.offer.OfferEditUI;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.offer.thesaurus.ThesaurusHandler;
import com.jurismarches.vradi.ui.renderers.VradiI18nTableCellRenderer;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.NumberFormatter;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyProxy;

public class UIHelper
extends SwingUtil {
    private static final Log log = LogFactory.getLog(UIHelper.class);

    private UIHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateListSelection(JList list, Object value) {
        list.setValueIsAdjusting(true);
        list.clearSelection();
        try {
            if (value != null) {
                int size = list.getModel().getSize();
                Collection valuesToSelect = (Collection)value;
                int[] indexToSelect = new int[valuesToSelect.size()];
                int index = 0;
                block3: for (Object v : valuesToSelect) {
                    for (int i = 0; i < size; ++i) {
                        Object o = list.getModel().getElementAt(i);
                        if (!o.equals(v)) continue;
                        indexToSelect[index++] = i;
                        continue block3;
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("index to select = " + Arrays.toString(indexToSelect)));
                }
                list.setSelectedIndices(indexToSelect);
            }
        }
        finally {
            list.setValueIsAdjusting(false);
        }
    }

    public static void setI18nTableHeaderRenderer(JTable table, String ... libelles) {
        table.getTableHeader().setDefaultRenderer((TableCellRenderer)((Object)new VradiI18nTableCellRenderer(table.getTableHeader().getDefaultRenderer(), libelles)));
    }

    public static void openAddressInBrowser(String address) {
        if (address != null) {
            try {
                UIHelper.browseURI("http://maps.google.fr/maps?f=q&source=s_q&hl=fr&geocode=&q=" + UIHelper.getStringValue((Object)address) + ",France");
            }
            catch (IOException eee) {
                log.error((Object)("Cant display page for address : " + UIHelper.getStringValue((Object)address)), (Throwable)eee);
                JOptionPane.showMessageDialog(null, I18n._((String)"message.cannot.display.address"));
            }
        }
    }

    public static void browseURI(URI uri) throws IOException {
        if (uri != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Browse URI : " + uri.toString()));
            }
            Desktop desktop = Desktop.getDesktop();
            desktop.browse(uri);
        }
    }

    public static void browseURI(String uri) throws IOException {
        if (uri != null) {
            try {
                UIHelper.browseURI(new URI(uri.replace(" ", "+")));
            }
            catch (URISyntaxException eee) {
                log.error((Object)("Cant display uri : " + uri), (Throwable)eee);
                ErrorDialogUI.showError((Exception)eee);
            }
        }
    }

    public static void browseURI(URL url) throws IOException {
        if (url != null) {
            String externalForm = url.toExternalForm();
            UIHelper.browseURI(externalForm);
        }
    }

    public static void createEmail(String emailAdress) throws IOException, URISyntaxException, UnsupportedOperationException {
        URI mailtoURI = new URI("mailto:" + emailAdress);
        Desktop.getDesktop().mail(mailtoURI);
    }

    public static void exportToCSV(File file, OfferListTableModel model) {
        try {
            int i;
            FileWriter fileWriter = new FileWriter(file);
            CSVWriter csvWriter = new CSVWriter((Writer)fileWriter);
            int columnCount = model.getColumnCount();
            String[] nextLine = new String[columnCount];
            for (i = 0; i < model.getColumnCount(); ++i) {
                nextLine[i] = I18n._((String)model.getColumnName(i));
            }
            csvWriter.writeNext(nextLine);
            for (i = 0; i < model.getRowCount(); ++i) {
                nextLine = new String[columnCount];
                for (int j = 0; j < model.getColumnCount(); ++j) {
                    String value;
                    Object valueAt = model.getValueAt(i, j);
                    if (valueAt == null) continue;
                    nextLine[j] = value = String.valueOf(valueAt);
                }
                csvWriter.writeNext(nextLine);
            }
            csvWriter.close();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
    }

    public static File openFileChooser(final String fileExtension, final String description, Component component, String validationLabel) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String ext = null;
                String fileName = file.getName();
                int dot = fileName.lastIndexOf(46);
                if (dot > 0 && dot < fileName.length() - 1) {
                    ext = fileName.substring(dot).toLowerCase();
                }
                return ext != null && ext.equals(fileExtension);
            }

            @Override
            public String getDescription() {
                return I18n._((String)description);
            }
        });
        int returnVal = fileChooser.showDialog(component, I18n._((String)validationLabel));
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            if (!file.getName().endsWith(fileExtension)) {
                file = new File(file.getAbsolutePath() + fileExtension);
            }
            log.debug((Object)("saving : " + file.getName() + "."));
            return file;
        }
        log.debug((Object)"No file chosen by user.");
        return null;
    }

    public static ListCellRenderer getTranslationListCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value != null) {
                    return super.getListCellRendererComponent((JList<?>)list, I18n._((String)value.toString()), index, isSelected, cellHasFocus);
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        };
    }

    public static <T> T getHandler(JAXXContext context, Class<T> handlerClass) {
        Object handler = context.getContextValue(handlerClass);
        if (handler != null) {
            return (T)handler;
        }
        try {
            handler = handlerClass.newInstance();
        }
        catch (InstantiationException e) {
            log.error((Object)("Cant create handler instance of type " + handlerClass.getName() + " : "), (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Cant create handler instance of type " + handlerClass.getName() + " : "), (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
        if (context instanceof JAXXInitialContext) {
            ((JAXXInitialContext)context).add(handler);
        } else {
            context.setContextValue(handler);
        }
        return (T)handler;
    }

    public static ComboBoxModel getNumberComboBoxModel(int startIndex, int nbData) {
        Integer[] data = new Integer[nbData];
        for (int i = startIndex; i < data.length; ++i) {
            data[i] = i;
        }
        return new DefaultComboBoxModel<Integer>(data);
    }

    public static ComboBoxModel getNumberComboBoxModel(int nbData) {
        return UIHelper.getNumberComboBoxModel(0, nbData);
    }

    public static ComboBoxModel getHourModel() {
        return UIHelper.getNumberComboBoxModel(24);
    }

    public static ComboBoxModel getMinuteModel() {
        return UIHelper.getNumberComboBoxModel(60);
    }

    public static ListCellRenderer get2DigitsRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object o, int i, boolean b, boolean b1) {
                String value = null;
                if (o != null) {
                    value = (Integer)o < 10 ? "0" + o.toString() : o.toString();
                }
                return super.getListCellRendererComponent((JList<?>)jList, value, i, b, b1);
            }
        };
    }

    public static ListCellRenderer getTranslationRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object o, int i, boolean b, boolean b1) {
                String value = null;
                if (o != null) {
                    value = o.toString();
                }
                return super.getListCellRendererComponent((JList<?>)jList, I18n._((String)value), i, b, b1);
            }
        };
    }

    public static WikittyProxy getProxy() {
        return VradiService.getWikittyProxy();
    }

    public static VradiDataService getDataService() {
        return VradiService.getVradiDataService();
    }

    public static EntityModel getXmlStreamsModel() {
        List streamList = UIHelper.getDataService().findAllXmlStreams();
        return new EntityModel<XmlStream>(XmlStream.class, "XmlStream", streamList);
    }

    public static ListModel getStatusesModel(boolean firstNull) {
        List<Status> status = AdminHandler.getAllStatuses();
        return new EntityModel<Status>(Status.class, "Status", status, firstNull);
    }

    public static ListCellRenderer getStatusCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Status status = (Status)value;
                return super.getListCellRendererComponent((JList<?>)list, I18n._((String)status.getName()), index, isSelected, cellHasFocus);
            }
        };
    }

    public static ComboBoxModel getFormTypesModel() {
        return new FormTypeModel(false);
    }

    public static ComboBoxModel getFormTypesModel(boolean firstNull) {
        return new FormTypeModel(firstNull);
    }

    public static <E extends BusinessEntity> ComboBoxModel getQueryMakersModel(Class<E> clazz, String ext, List<E> entities) {
        if (entities == null) {
            return new DefaultComboBoxModel();
        }
        return new EntityModel<E>(clazz, ext, entities, false);
    }

    public static ListModel getSendingModel(Map<?, Sending> entity) {
        if (entity == null) {
            return new DefaultListModel();
        }
        ArrayList<Sending> datas = new ArrayList<Sending>(entity.values());
        return new EntityModel<Sending>(Sending.class, "Sending", datas, false);
    }

    public static <E extends Component> E getContentIfExist(CardLayout2 contentLayout, JPanel content, Class<E> uiClass) {
        String contentName = uiClass.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get content if exist " + contentName));
        }
        if (!contentLayout.contains((Serializable)((Object)contentName))) {
            return null;
        }
        return (E)contentLayout.getComponent((Container)content, contentName);
    }

    public static void openFormPopup(JAXXContext context, Form form) {
        context.setContextValue((Object)form);
        OfferEditUI ui = (OfferEditUI)context.getContextValue(OfferEditUI.class, "formPopupOfferEditUI");
        if (ui == null) {
            ui = new OfferEditUI(context);
            context.setContextValue((Object)ui, "formPopupOfferEditUI");
        }
        ui.getContent().removeAll();
        OfferEditHandler handler = UIHelper.getHandler(context, OfferEditHandler.class);
        handler.fillfields(ui, form);
        UIHelper.getHandler(context, ThesaurusHandler.class).initThesaurus(ui);
        JDialog frame = (JDialog)context.getContextValue(JDialog.class, "formPopup");
        if (frame == null) {
            JDialog parent = null;
            Component c = (Component)context;
            while (parent == null && c != null) {
                if (JDialog.class.isAssignableFrom(c.getClass())) {
                    parent = (JDialog)c;
                    continue;
                }
                c = c.getParent();
            }
            frame = new JDialog(parent);
            frame.setLayout(new BorderLayout());
            frame.setSize(new Dimension(800, 800));
            frame.getContentPane().add((Component)ui, "Center");
            context.setContextValue((Object)frame, "formPopup");
        }
        frame.setTitle(form.getObjet());
        frame.setVisible(true);
    }

    public static void selectNodeLater(final NavHelper helper, final String id) {
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                NavNode node = helper.findNode(helper.getRootNode(), new String[]{id});
                while (node == null) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException eee) {
                        log.error((Object)("Cant select node with id : " + id), (Throwable)eee);
                        ErrorDialogUI.showError((Exception)eee);
                    }
                    node = helper.findNode(helper.getRootNode(), new String[]{id});
                }
                helper.selectNode(node);
            }
        });
    }

    public static void refreshNodeLater(final AdminNavigationTreeHelper helper, final String id) {
        final String selectedNodeID = helper.getSelectedNode() == null ? null : ((VradiTreeNode)helper.getSelectedNode()).getId();
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                VradiTreeNode node = (VradiTreeNode)helper.findNode(helper.getRootNode(), new String[]{id});
                while (node == null) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException eee) {
                        log.error((Object)("Cant select node with id : " + id), (Throwable)eee);
                        ErrorDialogUI.showError((Exception)eee);
                    }
                    node = (VradiTreeNode)helper.findNode(helper.getRootNode(), new String[]{id});
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Refresh node " + node.getId() + " with internal class " + node.getInternalClass()));
                }
                helper.refresh(node);
                VradiTreeNode selectedNode = (VradiTreeNode)helper.findNode(helper.getRootNode(), new String[]{selectedNodeID});
                if (selectedNode != null) {
                    String id2 = selectedNode.getId();
                    if (id2.contains("category")) {
                        helper.reSelectCategory(selectedNode);
                    } else {
                        helper.selectNode((NavNode)selectedNode);
                    }
                }
            }
        });
    }

    public static void addThesaurusExpandOnClickListener(final JTree tree) {
        tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(final TreeSelectionEvent e) {
                boolean isThesaurusExpanded = VradiHelper.isOnClickThesaurusExpanded();
                if (!isThesaurusExpanded) {
                    return;
                }
                TreeNode node = (TreeNode)e.getPath().getLastPathComponent();
                if (node != null && !node.isLeaf()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (TreePath path : e.getPaths()) {
                                if (!e.isAddedPath(path) || tree.isExpanded(path)) continue;
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("expand node [" + path + "]"));
                                }
                                tree.expandPath(path);
                            }
                        }
                    });
                }
            }
        });
    }

    public static void addThesaurusExpandOnClickListener(final JXTreeTable treeTable) {
        treeTable.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(final TreeSelectionEvent e) {
                TreeNode node = (TreeNode)e.getPath().getLastPathComponent();
                if (node != null && !node.isLeaf()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            boolean isThesaurusExpanded = VradiHelper.isOnClickThesaurusExpanded();
                            for (TreePath path : e.getPaths()) {
                                if (!e.isAddedPath(path) || treeTable.isExpanded(path)) continue;
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("expand node [" + path + "]"));
                                }
                                if (isThesaurusExpanded) {
                                    treeTable.expandPath(path);
                                }
                                treeTable.getTreeSelectionModel().setSelectionPath(path);
                            }
                        }
                    });
                }
            }
        });
    }

    public static class NumberFormatterFactory
    extends JFormattedTextField.AbstractFormatterFactory {
        @Override
        public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
            numberFormatter.setAllowsInvalid(false);
            numberFormatter.setValueClass(Integer.class);
            return numberFormatter;
        }
    }
}

