/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email.helpers;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.EmailContentUI;
import com.jurismarches.vradi.ui.email.FormViewUI;
import com.jurismarches.vradi.ui.email.SessionsListUI;
import com.jurismarches.vradi.ui.email.helpers.EmailDataHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import java.text.SimpleDateFormat;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyProxy;

public enum EmailBeanConstant {
    GROUP(Group.class, SessionsListUI.class),
    USER(User.class, SessionsListUI.class),
    FORM(Form.class, FormViewUI.class),
    SESSION(Session.class, SessionsListUI.class);

    protected Class<? extends BusinessEntity> beanClass;
    protected Class<? extends EmailContentUI> uiClass;

    private EmailBeanConstant(Class<? extends BusinessEntity> beanClass, Class<? extends EmailContentUI> uiClass) {
        this.beanClass = beanClass;
        this.uiClass = uiClass;
    }

    public Class<? extends BusinessEntity> getBeanClass() {
        return this.beanClass;
    }

    public Class<? extends EmailContentUI> getUIClass() {
        return this.uiClass;
    }

    public static EmailBeanConstant getConstantByBeanClass(Class<?> beanClass) {
        for (EmailBeanConstant constant : EmailBeanConstant.values()) {
            if (!beanClass.equals(constant.getBeanClass())) continue;
            return constant;
        }
        return null;
    }

    public BusinessEntity getBean(VradiDataProvider provider, String id) {
        WikittyProxy proxy = provider.getWikittyProxy();
        return proxy.restore(this.beanClass, id);
    }

    public static Class<? extends EmailContentUI> getUIClass(Class<?> beanClass) {
        for (EmailBeanConstant constant : EmailBeanConstant.values()) {
            if (!beanClass.equals(constant.getBeanClass())) continue;
            return constant.getUIClass();
        }
        return null;
    }

    public String decorate(Session currentSession, BusinessEntity bean) {
        String result = "";
        switch (this) {
            case GROUP: {
                Group group = this.cast(Group.class, bean);
                result = group.getName() + " (" + EmailDataHelper.getNbFormToSend(currentSession, group) + ")";
                break;
            }
            case USER: {
                User user = this.cast(User.class, bean);
                Client client = (Client)VradiService.getWikittyProxy().restore(Client.class, user.getClient());
                result = client.getName() + " - " + user.getName() + " (" + EmailDataHelper.getNbFormToSend(currentSession, user) + ")";
                break;
            }
            case FORM: {
                Form form = this.cast(Form.class, bean);
                result = form.getObjet();
                break;
            }
            case SESSION: {
                Session session = this.cast(Session.class, bean);
                StringBuffer buffer = new StringBuffer();
                buffer.append(session.getNum());
                buffer.append(" - ");
                SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
                buffer.append(format.format(session.getSessionDate()));
                buffer.append(" (");
                buffer.append(EmailDataHelper.getNbFormToSend(session));
                buffer.append(")");
                buffer.append(" - ");
                buffer.append(VradiConstants.SessionStatus.getStatus((int)session.getStatus()).getDescription());
                result = buffer.toString();
            }
        }
        return result;
    }

    protected <B extends BusinessEntity> B cast(Class<B> toCast, BusinessEntity bean) {
        return (B)bean;
    }
}

