/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemplateFieldTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(TemplateFieldTableModel.class);
    protected List<Map.Entry<String, String>> data = new ArrayList<Map.Entry<String, String>>();
    protected boolean valueIsAdjusting;

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    public void clear() {
        this.data.clear();
        if (!this.valueIsAdjusting) {
            this.fireTableDataChanged();
        }
    }

    public boolean isValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
    }

    public Map<String, String> getData() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.data) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public void setData(Map<String, String> data) {
        this.data.addAll(data.entrySet());
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        this.ensureColumnIndex(columnIndex);
        this.ensureRowIndex(rowIndex);
        Map.Entry<String, String> entry = this.data.get(rowIndex);
        Object result = null;
        switch (columnIndex) {
            case 0: {
                result = entry.getKey();
                break;
            }
            case 1: {
                String value = entry.getValue();
                if (value == null) break;
                result = Collections.singletonList(value);
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object sValue, int rowIndex, int columnIndex) {
        this.ensureColumnIndex(columnIndex);
        this.ensureRowIndex(rowIndex);
        Map.Entry<String, String> entry = this.data.get(rowIndex);
        Object[] value = (Object[])sValue;
        entry.setValue(value.length > 0 ? (String)value[0] : null);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    protected void ensureRowIndex(int rowIndex) {
        if (rowIndex >= this.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException("rowIndex (" + rowIndex + ") can not be greater than " + this.getRowCount());
        }
    }

    protected void ensureColumnIndex(int columnIndex) {
        if (columnIndex >= this.getColumnCount()) {
            throw new ArrayIndexOutOfBoundsException("columnIndex (" + columnIndex + ") can not be greater than " + this.getColumnCount());
        }
    }
}

