/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Map;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"})
public class RpcDispatcherInterruptTest
extends ChannelTestBase {
    private RpcDispatcher disp;
    private RpcDispatcher disp2;
    private JChannel ch;
    private JChannel ch2;

    @BeforeMethod
    void setUp() throws Exception {
        this.ch = this.createChannel(true);
        RpcDispatcherInterruptTest.modifyStack(this.ch);
        ServerObject obj = new ServerObject();
        this.disp = new RpcDispatcher((Channel)this.ch, null, null, obj);
        this.ch.connect("RpcDispatcherInterruptTest");
        this.ch2 = this.createChannel(this.ch);
        ServerObject obj2 = new ServerObject();
        this.disp2 = new RpcDispatcher((Channel)this.ch2, null, null, obj2);
        this.ch2.connect("RpcDispatcherInterruptTest");
    }

    @AfterMethod
    void tearDown() throws Exception {
        this.ch2.close();
        this.disp2.stop();
        this.ch.close();
        this.disp.stop();
    }

    public void testMethodCallWithTimeoutNoInterrupt() {
        long timeout = 0L;
        long block_time = 0L;
        RspList rsps = this.call(timeout, block_time);
        RpcDispatcherInterruptTest.checkResults(rsps, 2, true);
        timeout = 0L;
        block_time = 1000L;
        rsps = this.call(timeout, block_time);
        RpcDispatcherInterruptTest.checkResults(rsps, 2, true);
        timeout = 1000L;
        block_time = 0L;
        rsps = this.call(timeout, block_time);
        RpcDispatcherInterruptTest.checkResults(rsps, 2, true);
        timeout = 1000L;
        block_time = 10000L;
        rsps = this.call(timeout, block_time);
        RpcDispatcherInterruptTest.checkResults(rsps, 2, false);
    }

    private static void modifyStack(JChannel ch) {
        ProtocolStack stack = ch.getProtocolStack();
        GMS gms = (GMS)stack.findProtocol(GMS.class);
        if (gms != null) {
            gms.setLogCollectMessages(false);
        }
    }

    private RspList call(long timeout, long block_time) {
        System.out.println("calling with timeout=" + timeout + ", block_time=" + block_time);
        long start = System.currentTimeMillis();
        RspList retval = this.disp.callRemoteMethods(null, "foo", new Object[]{block_time}, new Class[]{Long.TYPE}, 2, timeout);
        long stop = System.currentTimeMillis();
        long diff = stop - start;
        System.out.println("rsps (in " + diff + "ms:)\n" + retval);
        return retval;
    }

    private static void checkResults(RspList rsps, int num, boolean received) {
        RpcDispatcherInterruptTest.assertEquals("responses: " + rsps, num, rsps.size());
        for (Map.Entry<Address, Rsp> entry : rsps.entrySet()) {
            Rsp rsp = entry.getValue();
            RpcDispatcherInterruptTest.assertEquals("rsp: " + rsp, rsp.wasReceived(), received);
        }
    }

    static class ServerObject {
        ServerObject() {
        }

        public static void foo(long timeout) {
            Util.sleep(timeout);
        }
    }
}

