/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.ViewId;

public class MergeView
extends View {
    protected Vector<View> subgroups = null;

    public MergeView() {
    }

    public MergeView(ViewId vid, Vector<Address> members, Vector<View> subgroups) {
        super(vid, members);
        this.subgroups = subgroups;
    }

    public MergeView(Address creator, long id, Vector<Address> members, Vector<View> subgroups) {
        super(creator, id, members);
        this.subgroups = subgroups;
    }

    public Vector<View> getSubgroups() {
        return this.subgroups;
    }

    @Override
    public Object clone() {
        ViewId vid2 = this.vid != null ? (ViewId)this.vid.clone() : null;
        Vector members2 = this.members != null ? (Vector)this.members.clone() : null;
        Vector subgroups2 = this.subgroups != null ? (Vector)this.subgroups.clone() : null;
        return new MergeView(vid2, members2, subgroups2);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MergeView::").append(super.toString()).append(", subgroups=").append(this.subgroups);
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.subgroups);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.subgroups = (Vector)in.readObject();
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        super.writeTo(out);
        int len = this.subgroups != null ? this.subgroups.size() : 0;
        out.writeShort(len);
        if (len == 0) {
            return;
        }
        for (View v : this.subgroups) {
            if (v instanceof MergeView) {
                out.writeBoolean(true);
            } else {
                out.writeBoolean(false);
            }
            v.writeTo(out);
        }
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        super.readFrom(in);
        int len = in.readShort();
        if (len > 0) {
            this.subgroups = new Vector();
            for (int i = 0; i < len; ++i) {
                boolean is_merge_view = in.readBoolean();
                View v = is_merge_view ? new MergeView() : new View();
                v.readFrom(in);
                this.subgroups.add(v);
            }
        }
    }

    @Override
    public int serializedSize() {
        int retval = super.serializedSize();
        retval += 2;
        if (this.subgroups == null) {
            return retval;
        }
        for (View v : this.subgroups) {
            ++retval;
            retval += v.serializedSize();
        }
        return retval;
    }
}

