/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import java.util.StringTokenizer;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CleanerTransformations;
import org.htmlcleaner.SpecialEntities;
import org.htmlcleaner.TagTransformation;

public class Utils {
    public static String VAR_START = "${";
    public static String VAR_END = "}";

    public static String ltrim(String s) {
        int index;
        if (s == null) {
            return null;
        }
        int len = s.length();
        for (index = 0; index < len && Character.isWhitespace(s.charAt(index)); ++index) {
        }
        return index >= len ? "" : s.substring(index);
    }

    public static String rtrim(String s) {
        int len;
        int index;
        if (s == null) {
            return null;
        }
        for (index = len = s.length(); index > 0 && Character.isWhitespace(s.charAt(index - 1)); --index) {
        }
        return index <= 0 ? "" : s.substring(0, index);
    }

    public static StringBuffer readUrl(URL url, String charset) throws IOException {
        StringBuffer buffer = new StringBuffer(1024);
        Object content = url.getContent();
        if (content instanceof InputStream) {
            InputStreamReader reader = new InputStreamReader((InputStream)content, charset);
            char[] charArray = new char[1024];
            int charsRead = 0;
            do {
                if ((charsRead = reader.read(charArray)) < 0) continue;
                buffer.append(charArray, 0, charsRead);
            } while (charsRead > 0);
        }
        return buffer;
    }

    public static boolean isHexadecimalDigit(char ch) {
        return Character.isDigit(ch) || ch == 'A' || ch == 'a' || ch == 'B' || ch == 'b' || ch == 'C' || ch == 'c' || ch == 'D' || ch == 'd' || ch == 'E' || ch == 'e' || ch == 'F' || ch == 'f';
    }

    public static String escapeXml(String s, CleanerProperties props, boolean isDomCreation) {
        boolean advanced = props.isAdvancedXmlEscape();
        boolean recognizeUnicodeChars = props.isRecognizeUnicodeChars();
        boolean translateSpecialEntities = props.isTranslateSpecialEntities();
        if (s != null) {
            int len = s.length();
            StringBuffer result = new StringBuffer(len);
            for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                if (ch == '&') {
                    String entity;
                    Integer code;
                    String seq;
                    int semiIndex;
                    if ((advanced || recognizeUnicodeChars) && i < len - 1 && s.charAt(i + 1) == '#') {
                        int charIndex;
                        String unicode = "";
                        for (charIndex = i + 2; charIndex < len && (Utils.isHexadecimalDigit(s.charAt(charIndex)) || s.charAt(charIndex) == 'x' || s.charAt(charIndex) == 'X'); ++charIndex) {
                            unicode = unicode + s.charAt(charIndex);
                        }
                        if (charIndex == len || !"".equals(unicode)) {
                            try {
                                char unicodeChar;
                                char c = unicodeChar = unicode.toLowerCase().startsWith("x") ? (char)Integer.parseInt(unicode.substring(1), 16) : (char)Integer.parseInt(unicode);
                                if ("&<>'\"".indexOf(unicodeChar) < 0) {
                                    int replaceChunkSize = charIndex < len && s.charAt(charIndex) == ';' ? unicode.length() + 1 : unicode.length();
                                    result.append(recognizeUnicodeChars ? String.valueOf(unicodeChar) : "&#" + unicode + ";");
                                    i += replaceChunkSize + 1;
                                    continue;
                                }
                                i = charIndex;
                                result.append("&amp;#" + unicode + ";");
                            }
                            catch (NumberFormatException e) {
                                i = charIndex;
                                result.append("&amp;#" + unicode + ";");
                            }
                            continue;
                        }
                        result.append("&amp;");
                        continue;
                    }
                    if (translateSpecialEntities && (semiIndex = (seq = s.substring(i, i + Math.min(10, len - i))).indexOf(59)) > 0 && (code = (Integer)SpecialEntities.entities.get(entity = seq.substring(1, semiIndex))) != null) {
                        int entityLen = entity.length();
                        if (recognizeUnicodeChars) {
                            result.append((char)code.intValue());
                        } else {
                            result.append("&#" + code + ";");
                        }
                        i += entityLen + 1;
                        continue;
                    }
                    if (advanced) {
                        String sub = s.substring(i);
                        if (sub.startsWith("&amp;")) {
                            result.append(isDomCreation ? "&" : "&amp;");
                            i += 4;
                            continue;
                        }
                        if (sub.startsWith("&apos;")) {
                            result.append(isDomCreation ? "'" : "&apos;");
                            i += 5;
                            continue;
                        }
                        if (sub.startsWith("&gt;")) {
                            result.append(isDomCreation ? ">" : "&gt;");
                            i += 3;
                            continue;
                        }
                        if (sub.startsWith("&lt;")) {
                            result.append(isDomCreation ? "<" : "&lt;");
                            i += 3;
                            continue;
                        }
                        if (sub.startsWith("&quot;")) {
                            result.append(isDomCreation ? "\"" : "&quot;");
                            i += 5;
                            continue;
                        }
                        result.append(isDomCreation ? "&" : "&amp;");
                        continue;
                    }
                    result.append("&amp;");
                    continue;
                }
                if (ch == '\'') {
                    result.append("&apos;");
                    continue;
                }
                if (ch == '>') {
                    result.append("&gt;");
                    continue;
                }
                if (ch == '<') {
                    result.append("&lt;");
                    continue;
                }
                if (ch == '\"') {
                    result.append("&quot;");
                    continue;
                }
                result.append(ch);
            }
            return result.toString();
        }
        return null;
    }

    public static boolean isWhitespaceString(Object object) {
        if (object != null) {
            String s = object.toString();
            return s != null && "".equals(s.trim());
        }
        return false;
    }

    public static boolean isIdentifierHelperChar(char ch) {
        return ':' == ch || '.' == ch || '-' == ch || '_' == ch;
    }

    public static boolean isValidXmlIdentifier(String s) {
        if (s != null) {
            int len = s.length();
            if (len == 0) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                if ((i != 0 || Character.isUnicodeIdentifierStart(ch)) && (Character.isUnicodeIdentifierStart(ch) || Character.isDigit(ch) || Utils.isIdentifierHelperChar(ch))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isEmptyString(Object o) {
        return o == null || "".equals(o.toString().trim());
    }

    public static String evaluateTemplate(String template, Map variables) {
        if (template == null) {
            return template;
        }
        StringBuffer result = new StringBuffer();
        int startIndex = template.indexOf(VAR_START);
        int endIndex = -1;
        while (startIndex >= 0 && startIndex < template.length()) {
            result.append(template.substring(endIndex + 1, startIndex));
            endIndex = template.indexOf(VAR_END, startIndex);
            if (endIndex > startIndex) {
                String varName = template.substring(startIndex + VAR_START.length(), endIndex);
                String resultObj = variables != null ? variables.get(varName.toLowerCase()) : "";
                result.append(resultObj == null ? "" : resultObj.toString());
            }
            startIndex = template.indexOf(VAR_START, Math.max(endIndex + VAR_END.length(), startIndex + 1));
        }
        result.append(template.substring(endIndex + 1));
        return result.toString();
    }

    public static String[] tokenize(String s, String delimiters) {
        if (s == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters);
        String[] result = new String[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            result[index++] = tokenizer.nextToken();
        }
        return result;
    }

    public static void updateTagTransformations(CleanerTransformations transformations, String key, String value) {
        int index = key.indexOf(46);
        if (index <= 0) {
            String destTag = null;
            boolean preserveSourceAtts = true;
            if (value != null) {
                String[] tokens = Utils.tokenize(value, ",;");
                if (tokens.length > 0) {
                    destTag = tokens[0];
                }
                if (tokens.length > 1) {
                    preserveSourceAtts = "true".equalsIgnoreCase(tokens[1]) || "yes".equalsIgnoreCase(tokens[1]) || "1".equals(tokens[1]);
                }
            }
            TagTransformation newTagTrans = new TagTransformation(key, destTag, preserveSourceAtts);
            transformations.addTransformation(newTagTrans);
        } else {
            String[] parts = Utils.tokenize(key, ".");
            String tagName = parts[0];
            TagTransformation trans = transformations.getTransformation(tagName);
            if (trans != null) {
                trans.addAttributeTransformation(parts[1], value);
            }
        }
    }
}

