/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.helpers;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI;
import com.jurismarches.vradi.ui.helpers.AdminNavigationTreeHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.navigation.NavigationModel;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.nuiton.i18n.I18n;

public class XmlStreamNavigationTreeHelper
extends AdminNavigationTreeHelper {
    protected NavigationModel<NavigationTreeNode> cachedModel;
    protected boolean datasChanged = false;

    public XmlStreamNavigationTreeHelper(JAXXContext context) {
        super(VradiContext.getXmlStreamEntryDef().getName(), context);
        JAXXContextEntryDef<List<XmlStream>> xmlStreamEntryDef = VradiContext.getXmlStreamEntryDef();
        VradiContext.get().addPropertyChangeListener(xmlStreamEntryDef, xmlStreamEntryDef.getName(), new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                XmlStreamNavigationTreeHelper.this.datasChanged = true;
            }
        });
    }

    @Override
    public NavigationModel<NavigationTreeNode> createTreeModel() {
        if (this.cachedModel != null && !this.datasChanged) {
            return this.cachedModel;
        }
        JAXXContext context = this.getContext();
        List<XmlStream> xmlStreams = VradiContext.getXmlStreamInEntryDef();
        NavigationTreeNode rootNode = (NavigationTreeNode)this.builder.buildEmptyRoot(null, "$root");
        JAXXContextEntryDef<List<XmlStream>> xmlStreamEntryDef = VradiContext.getXmlStreamEntryDef();
        NavigationTreeNode xmlStreamNode = (NavigationTreeNode)this.builder.build((NavigationNode)rootNode, I18n._((String)xmlStreamEntryDef.getName()), xmlStreamEntryDef, "xmlStreams", AdminXmlStreamUI.class, null);
        for (XmlStream x : xmlStreams) {
            this.builder.addXmlStream(context, xmlStreamNode, x);
        }
        this.cachedModel = this.builder.getModel();
        this.setModel(context, this.cachedModel);
        this.setSelectedNode(context, (NavigationNode)xmlStreamNode);
        this.datasChanged = false;
        return this.cachedModel;
    }

    @Override
    public NavigationTreeNode removeChildNode(NavigationTreeNode node) {
        List<XmlStream> streams = VradiContext.getXmlStreamInEntryDef();
        XmlStream bean = (XmlStream)node.getBean();
        streams.remove(bean);
        return super.removeChildNode(node);
    }
}

