/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.hook;

import java.lang.instrument.ClassDefinition;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.hook.Agent;
import org.codehaus.aspectwerkz.transform.inlining.compiler.CompilationInfo;
import org.codehaus.aspectwerkz.transform.inlining.compiler.JoinPointFactory;
import org.codehaus.aspectwerkz.transform.inlining.deployer.ChangeSet;
import org.codehaus.aspectwerkz.transform.inlining.deployer.Redefiner;

public class JVMTIRedefiner
implements Redefiner {
    public JVMTIRedefiner() {
        if (!Agent.getInstrumentation().isRedefineClassesSupported()) {
            throw new UnsupportedOperationException("This Java 5 does not support JVMTI redefine()");
        }
    }

    public void redefine(ChangeSet changeSet) {
        if (!Agent.getInstrumentation().isRedefineClassesSupported()) {
            return;
        }
        ClassDefinition[] changes = new ClassDefinition[changeSet.getElements().size()];
        int index = 0;
        for (ChangeSet.Element changeSetElement : changeSet.getElements()) {
            byte[] bytecode = JoinPointFactory.redefineJoinPoint((CompilationInfo)changeSetElement.getCompilationInfo());
            changes[index] = new ClassDefinition(changeSetElement.getJoinPointInfo().getJoinPointClass(), bytecode);
            ++index;
        }
        try {
            Agent.getInstrumentation().redefineClasses(changes);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException((Throwable)e);
        }
    }
}

