/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.multistorage;

import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyStorage;
import org.sharengo.wikitty.WikittyTransaction;
import org.sharengo.wikitty.multistorage.MultiStorageConfiguration;

public class WikittyMultiStorage
implements WikittyStorage {
    private static Log log = LogFactory.getLog(WikittyMultiStorage.class);
    protected MultiStorageConfiguration configuration;

    public WikittyMultiStorage(MultiStorageConfiguration configuration) {
        this.configuration = configuration;
    }

    public UpdateResponse store(WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean disableAutoVersionIncrement) {
        List<WikittyStorage> wikittyStorageMasters = this.configuration.getWikittyStorageMasters();
        for (WikittyStorage wikittyStorage : wikittyStorageMasters) {
            wikittyStorage.store(transaction, wikitties, disableAutoVersionIncrement);
        }
        List<WikittyStorage> wikittyStorageReplications = this.configuration.getWikittyStorageReplications();
        for (WikittyStorage wikittyStorage : wikittyStorageReplications) {
            wikittyStorage.store(transaction, wikitties, disableAutoVersionIncrement);
        }
        UpdateResponse result = new UpdateResponse();
        return result;
    }

    public boolean exists(WikittyTransaction transaction, String id) {
        WikittyStorage currentMasterWikittyStorage = this.configuration.getCurrentMasterWikittyStorage();
        boolean result = currentMasterWikittyStorage.exists(transaction, id);
        return result;
    }

    public boolean isDeleted(WikittyTransaction transaction, String id) {
        WikittyStorage currentMasterWikittyStorage = this.configuration.getCurrentMasterWikittyStorage();
        boolean result = currentMasterWikittyStorage.isDeleted(transaction, id);
        return result;
    }

    public Wikitty restore(WikittyTransaction transaction, String id, String ... fqFieldName) throws WikittyException {
        WikittyStorage currentMasterWikittyStorage = this.configuration.getCurrentMasterWikittyStorage();
        Wikitty result = currentMasterWikittyStorage.restore(transaction, id, fqFieldName);
        return result;
    }

    public UpdateResponse delete(WikittyTransaction transaction, Collection<String> idList) throws WikittyException {
        List<WikittyStorage> wikittyStorageMasters = this.configuration.getWikittyStorageMasters();
        for (WikittyStorage wikittyStorage : wikittyStorageMasters) {
            wikittyStorage.delete(transaction, idList);
        }
        List<WikittyStorage> wikittyStorageReplications = this.configuration.getWikittyStorageReplications();
        for (WikittyStorage wikittyStorage : wikittyStorageReplications) {
            wikittyStorage.delete(transaction, idList);
        }
        UpdateResponse result = new UpdateResponse();
        return result;
    }

    public void scanWikitties(WikittyTransaction transaction, WikittyStorage.Scanner scanner) {
        WikittyStorage currentMasterWikittyStorage = this.configuration.getCurrentMasterWikittyStorage();
        currentMasterWikittyStorage.scanWikitties(transaction, scanner);
    }

    public void clear(WikittyTransaction transaction) {
        List<WikittyStorage> wikittyStorageMasters = this.configuration.getWikittyStorageMasters();
        for (WikittyStorage wikittyStorage : wikittyStorageMasters) {
            wikittyStorage.clear(transaction);
        }
        List<WikittyStorage> wikittyStorageReplications = this.configuration.getWikittyStorageReplications();
        for (WikittyStorage wikittyStorage : wikittyStorageReplications) {
            wikittyStorage.clear(transaction);
        }
    }
}

