/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import jaxx.runtime.validator.BeanValidator;
import jaxx.runtime.validator.BeanValidatorScope;
import org.nuiton.i18n.I18n;

public class BeanValidatorField<B> {
    protected final Class<B> beanClass;
    protected final String name;
    protected EnumMap<BeanValidatorScope, Set<String>> messages;

    public BeanValidatorField(Class<B> beanClass, String name, List<BeanValidatorScope> scopes) {
        this.beanClass = beanClass;
        this.name = name;
        this.messages = new EnumMap(BeanValidatorScope.class);
        for (BeanValidatorScope scope : scopes) {
            this.messages.put(scope, new HashSet());
        }
    }

    public String getName() {
        return this.name;
    }

    public Class<B> getBeanClass() {
        return this.beanClass;
    }

    public boolean isValid() {
        return !this.hasErrors();
    }

    public BeanValidatorScope getScope() {
        if (this.hasErrors()) {
            return BeanValidatorScope.ERROR;
        }
        if (this.hasWarnings()) {
            return BeanValidatorScope.WARNING;
        }
        if (this.hasInfos()) {
            return BeanValidatorScope.INFO;
        }
        return null;
    }

    public Set<BeanValidatorScope> getScopes() {
        return this.messages.keySet();
    }

    public boolean hasErrors() {
        return this.hasMessages(BeanValidatorScope.ERROR);
    }

    public boolean hasWarnings() {
        return this.hasMessages(BeanValidatorScope.WARNING);
    }

    public boolean hasInfos() {
        return this.hasMessages(BeanValidatorScope.INFO);
    }

    public Set<String> getErrors() {
        return this.getMessages(BeanValidatorScope.ERROR);
    }

    public Set<String> getWarnings() {
        return this.getMessages(BeanValidatorScope.WARNING);
    }

    public Set<String> getInfos() {
        return this.getMessages(BeanValidatorScope.INFO);
    }

    public boolean hasMessages(BeanValidatorScope scope) {
        return this.messages.containsKey((Object)scope) && !this.getMessages(scope).isEmpty();
    }

    public Set<String> getMessages(BeanValidatorScope scope) {
        return this.messages.get((Object)scope);
    }

    public void updateMessages(BeanValidator<B> validator, BeanValidatorScope scope, List<String> messages) {
        if (scope == null) {
            for (BeanValidatorScope s : this.getScopes()) {
                this.clearMessages(s, validator);
            }
            return;
        }
        if (!this.messages.containsKey((Object)scope)) {
            throw new IllegalArgumentException("the scope " + (Object)((Object)scope) + " was not registred for " + this);
        }
        if (messages == null || messages.isEmpty()) {
            this.clearMessages(scope, validator);
            return;
        }
        boolean hasChanged = false;
        Set<String> currentMessages = this.getMessages(scope);
        HashSet<String> toDelete = new HashSet<String>(currentMessages);
        toDelete.removeAll(messages);
        if (!toDelete.isEmpty()) {
            currentMessages.removeAll(toDelete);
            hasChanged = true;
        }
        HashSet<String> toAdd = new HashSet<String>(messages);
        toAdd.removeAll(currentMessages);
        if (!toAdd.isEmpty()) {
            currentMessages.addAll(toAdd);
            hasChanged = true;
        }
        if (hasChanged) {
            String[] del = toDelete.toArray(new String[toDelete.size()]);
            String[] add = toAdd.toArray(new String[toAdd.size()]);
            validator.fireFieldChanged(this, scope, add, del);
        }
        toAdd.clear();
        toDelete.clear();
    }

    public String getI18nError(String error) {
        String text;
        if (!error.contains("##")) {
            text = I18n._((String)error);
        } else {
            StringTokenizer stk = new StringTokenizer(error, "##");
            String errorName = stk.nextToken();
            ArrayList<String> args = new ArrayList<String>();
            while (stk.hasMoreTokens()) {
                args.add(stk.nextToken());
            }
            text = I18n._((String)errorName, (Object[])args.toArray());
        }
        return text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BeanValidatorField)) {
            return false;
        }
        BeanValidatorField that = (BeanValidatorField)o;
        return this.beanClass.equals(that.beanClass) && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.beanClass.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(super.toString());
        sb.append(" beanClass:").append(this.beanClass);
        sb.append(", name:").append(this.name);
        sb.append(", scopes:");
        sb.append(this.messages == null ? "[]" : this.messages.keySet());
        sb.append(", scope:").append((Object)this.getScope());
        sb.append('>');
        return sb.toString();
    }

    protected void clearMessages(BeanValidatorScope scope, BeanValidator<B> validator) {
        Set<String> toDelete = this.getMessages(scope);
        if (!toDelete.isEmpty()) {
            String[] toDel = toDelete.toArray(new String[toDelete.size()]);
            toDelete.clear();
            validator.fireFieldChanged(this, scope, null, toDel);
        }
    }
}

